/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.texture;

import com.mojang.blaze3d.platform.TextureUtil;
import java.awt.image.BufferedImage;
import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.Set;
import journeymap.client.log.JMLogger;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.task.multi.MapPlayerTask;
import journeymap.common.Journeymap;
import net.minecraft.world.level.ChunkPos;
import org.lwjgl.BufferUtils;

public class RegionTextureImpl
extends TextureImpl {
    protected HashSet<ChunkPos> dirtyChunks = new HashSet();

    public RegionTextureImpl(BufferedImage image) {
        super(null, image, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(BufferedImage bufferedImage, boolean retainImage, HashSet<ChunkPos> updatedChunks) {
        if (updatedChunks.size() > 15) {
            super.setImage(bufferedImage, retainImage);
        } else {
            this.dirtyChunks.addAll(updatedChunks);
            this.bindNeeded = true;
            try {
                this.bufferLock.lock();
                this.retainImage = retainImage;
                if (retainImage) {
                    this.image = bufferedImage;
                }
                this.width = bufferedImage.getWidth();
                this.height = bufferedImage.getHeight();
            }
            finally {
                this.bufferLock.unlock();
            }
        }
        this.lastImageUpdate = System.currentTimeMillis();
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void m_117966_() {
        if (!this.bindNeeded) {
            return;
        }
        if (this.f_117950_ == -1) {
            this.f_117950_ = TextureUtil.m_85280_();
        }
        if (this.lastBound == 0L || this.dirtyChunks.isEmpty()) {
            super.m_117966_();
            return;
        }
        if (this.bufferLock.tryLock()) {
            MapPlayerTask.addTempDebugMessage("tex" + this.f_117950_, "Updating " + this.dirtyChunks.size() + " chunks within: " + this.getDescription());
            RenderWrapper.activeTexture(33984);
            RenderWrapper.bindTextureForSetup(this.f_117950_);
            RenderWrapper.setShaderTexture(0, this.f_117950_);
            RenderWrapper.texParameter(3553, 10242, 10497);
            RenderWrapper.texParameter(3553, 10243, 10497);
            RenderWrapper.texParameter(3553, 10241, 9729);
            RenderWrapper.texParameter(3553, 10240, 9729);
            try {
                boolean glErrors = false;
                IntBuffer chunkBuffer = BufferUtils.createIntBuffer((int)1024);
                for (ChunkPos pos : this.dirtyChunks) {
                    int err;
                    BufferedImage chunkImage = this.getImage().getSubimage(pos.f_45578_, pos.f_45579_, 16, 16);
                    RegionTextureImpl.loadIntBuffer(chunkImage, chunkBuffer);
                    RenderWrapper.pixelStore(3312, 0);
                    RenderWrapper.pixelStore(3313, 0);
                    RenderWrapper.pixelStore(3314, 0);
                    RenderWrapper.pixelStore(3315, 0);
                    RenderWrapper.pixelStore(3316, 0);
                    RenderWrapper.pixelStore(3317, 4);
                    RenderWrapper.texSubImage2D(3553, 0, pos.f_45578_, pos.f_45579_, 16, 16, 32993, 33639, chunkBuffer);
                    RenderWrapper.texParameter(3553, 10240, 9728);
                    RenderWrapper.texParameter(3553, 10241, 9729);
                    while ((err = RenderWrapper.getError()) != 0) {
                        glErrors = true;
                        JMLogger.logOnce("GL Error in RegionTextureImpl after glTexSubImage2D: " + err + " for " + pos + " in " + this, null);
                    }
                    if (!glErrors) continue;
                    break;
                }
                this.dirtyChunks.clear();
                if (glErrors) {
                    this.bindNeeded = true;
                } else {
                    this.bindNeeded = false;
                    this.lastBound = System.currentTimeMillis();
                }
            }
            catch (Throwable t) {
                Journeymap.getLogger().warn("Can't bind texture: " + t);
                this.buffer = null;
            }
            finally {
                this.bufferLock.unlock();
            }
        }
    }

    public Set<ChunkPos> getDirtyAreas() {
        return this.dirtyChunks;
    }
}

