/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.blockentity;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.pavocado.exoticbirds.config.ExoticBirdsCommonConfig;
import net.pavocado.exoticbirds.entity.AbstractPhoenixEntity;
import net.pavocado.exoticbirds.init.ExoticBirdsBlockEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import org.jetbrains.annotations.Nullable;

public class PhoenixEggBlockEntity
extends BlockEntity {
    private final EntityType<? extends AbstractPhoenixEntity> phoenixType;
    public static final int totalHatchTime = 48000;
    public int hatchTime = 48000;

    public PhoenixEggBlockEntity(BlockPos pos, BlockState state, EntityType<? extends AbstractPhoenixEntity> entityType) {
        super((BlockEntityType)ExoticBirdsBlockEntities.PHOENIX_EGG.get(), pos, state);
        this.phoenixType = entityType;
    }

    public PhoenixEggBlockEntity(BlockPos pos, BlockState state) {
        this(pos, state, null);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, PhoenixEggBlockEntity entity) {
        if (--entity.hatchTime <= 0) {
            entity.hatchEgg();
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.hatchTime = tag.m_128451_("HatchTime");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("HatchTime", this.hatchTime);
    }

    private void hatchEgg() {
        if (this.f_58857_ != null) {
            AbstractPhoenixEntity spawnEntity;
            this.f_58857_.m_7471_(this.f_58858_, false);
            AbstractPhoenixEntity phoenix = (AbstractPhoenixEntity)this.getPhoenixType().m_20615_(this.f_58857_);
            if (((Boolean)ExoticBirdsCommonConfig.allowPhoenixEggHatching.get()).booleanValue()) {
                spawnEntity = phoenix;
            } else {
                spawnEntity = (AgeableMob)EntityType.f_20555_.m_20615_(this.f_58857_);
                if (spawnEntity != null && phoenix != null) {
                    spawnEntity.m_6593_(phoenix.m_7755_());
                    spawnEntity.m_20340_(true);
                }
            }
            if (spawnEntity != null) {
                spawnEntity.m_146762_(-24000);
                spawnEntity.m_7678_((double)this.f_58858_.m_123341_() + 0.5, this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_() + 0.5, 0.0f, 0.0f);
                this.f_58857_.m_7967_((Entity)spawnEntity);
            }
            for (int i = 0; i < this.f_58857_.f_46441_.nextInt(3) + 5; ++i) {
                float d0float = this.f_58857_.f_46441_.nextFloat() - 0.5f;
                float d2float = this.f_58857_.f_46441_.nextFloat() - 0.5f;
                double d0 = (double)(d0float * 0.1f) + (double)d0float * 0.25;
                double d1 = (double)(this.f_58857_.f_46441_.nextFloat() * 0.1f) * 0.2 + 0.3;
                double d2 = (double)(d2float * 0.1f) + (double)d2float * 0.25;
                ItemStack itemstack = new ItemStack((ItemLike)ExoticBirdsItems.EGGSHELL.get(), 1);
                ItemEntity entityitem = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_() + 0.5, itemstack);
                entityitem.m_20334_(d0, d1, d2);
                entityitem.m_32010_(10);
                this.f_58857_.m_7967_((Entity)entityitem);
            }
        }
    }

    public EntityType<? extends AbstractPhoenixEntity> getPhoenixType() {
        if (this.phoenixType != null) {
            return this.phoenixType;
        }
        if (this.f_58857_ != null) {
            long timeToCheck = (long)this.hatchTime + this.f_58857_.m_8044_();
            long timeToCheckMod = timeToCheck % 24000L;
            if (this.f_58857_.m_6042_().m_63936_(timeToCheck) == 0 && timeToCheckMod >= 12542L && timeToCheckMod <= 23460L) {
                return (EntityType)ExoticBirdsEntities.TWILIGHT_PHOENIX.get();
            }
            BlockPos pos = this.f_58858_;
            if (this.f_58857_.m_46472_() == Level.f_46429_) {
                return (EntityType)ExoticBirdsEntities.NETHER_PHOENIX.get();
            }
            if (this.f_58857_.m_46472_() == Level.f_46430_) {
                return (EntityType)ExoticBirdsEntities.ENDER_PHOENIX.get();
            }
            Holder biome = this.f_58857_.m_204166_(pos);
            if (Biome.m_204183_((Holder)biome) == Biome.BiomeCategory.ICY) {
                return (EntityType)ExoticBirdsEntities.SNOWY_PHOENIX.get();
            }
            if (Biome.m_204183_((Holder)biome) == Biome.BiomeCategory.DESERT) {
                return (EntityType)ExoticBirdsEntities.DESERT_PHOENIX.get();
            }
            if (Biome.m_204183_((Holder)biome) == Biome.BiomeCategory.OCEAN) {
                return (EntityType)ExoticBirdsEntities.WATER_PHOENIX.get();
            }
            if (Biome.m_204183_((Holder)biome) == Biome.BiomeCategory.UNDERGROUND) {
                return (EntityType)ExoticBirdsEntities.SKELETON_PHOENIX.get();
            }
            if (pos.m_123342_() > 127) {
                return (EntityType)ExoticBirdsEntities.CLOUD_PHOENIX.get();
            }
        }
        return (EntityType)ExoticBirdsEntities.FIRE_PHOENIX.get();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }
}

