/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.stack;

import java.util.Collections;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeSlotChangeResult;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IStackableContentsUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public class StackUpgradeItem
extends UpgradeItemBase<Wrapper> {
    public static final UpgradeType<Wrapper> TYPE = new UpgradeType<Wrapper>(Wrapper::new);
    private final int stackSizeMultiplier;

    public StackUpgradeItem(int stackSizeMultiplier, CreativeModeTab itemGroup) {
        super(itemGroup);
        this.stackSizeMultiplier = stackSizeMultiplier;
    }

    public static int getInventorySlotLimit(IStorageWrapper storageWrapper) {
        int multiplier = 1;
        for (Wrapper stackWrapper : storageWrapper.getUpgradeHandler().getTypeWrappers(TYPE)) {
            if (Integer.MAX_VALUE / stackWrapper.getStackSizeMultiplier() < multiplier) {
                return Integer.MAX_VALUE;
            }
            multiplier *= stackWrapper.getStackSizeMultiplier();
        }
        return 0x1FFFFFF < multiplier ? Integer.MAX_VALUE : multiplier * 64;
    }

    @Override
    public UpgradeType<Wrapper> getType() {
        return TYPE;
    }

    int getStackSizeMultiplier() {
        return this.stackSizeMultiplier;
    }

    @Override
    public UpgradeSlotChangeResult canRemoveUpgradeFrom(IStorageWrapper storageWrapper) {
        int currentInventoryMultiplier = StackUpgradeItem.getInventorySlotLimit(storageWrapper) / 64;
        int multiplierWhenRemoved = currentInventoryMultiplier / this.stackSizeMultiplier;
        return this.isMultiplierHighEnough(storageWrapper, multiplierWhenRemoved);
    }

    @Override
    public UpgradeSlotChangeResult canSwapUpgradeFor(ItemStack upgradeStackToPut, IStorageWrapper storageWrapper) {
        Item item = upgradeStackToPut.m_41720_();
        if (!(item instanceof StackUpgradeItem)) {
            return this.canRemoveUpgradeFrom(storageWrapper);
        }
        StackUpgradeItem otherStackUpgradeItem = (StackUpgradeItem)item;
        if (otherStackUpgradeItem.stackSizeMultiplier >= this.stackSizeMultiplier) {
            return new UpgradeSlotChangeResult.Success();
        }
        int currentInventoryMultiplier = StackUpgradeItem.getInventorySlotLimit(storageWrapper) / 64;
        int multiplierWhenRemoved = currentInventoryMultiplier / this.stackSizeMultiplier;
        return this.isMultiplierHighEnough(storageWrapper, multiplierWhenRemoved * otherStackUpgradeItem.stackSizeMultiplier);
    }

    private UpgradeSlotChangeResult isMultiplierHighEnough(IStorageWrapper storageWrapper, int multiplier) {
        HashSet<Integer> slotsOverMultiplier = new HashSet<Integer>();
        InventoryHelper.iterate((IItemHandler)storageWrapper.getInventoryHandler(), (slot, stack) -> {
            int stackMultiplierNeeded = stack.m_41613_() / stack.m_41741_() + (stack.m_41613_() % stack.m_41741_() != 0 ? 1 : 0);
            if (stackMultiplierNeeded > multiplier) {
                slotsOverMultiplier.add((Integer)slot);
            }
        });
        HashSet<Integer> errorInventoryParts = new HashSet<Integer>();
        storageWrapper.getUpgradeHandler().getSlotWrappers().forEach((slot, wrapper) -> {
            IStackableContentsUpgrade stackableContentsUpgrade;
            if (wrapper instanceof IStackableContentsUpgrade && (stackableContentsUpgrade = (IStackableContentsUpgrade)((Object)wrapper)).getMinimumMultiplierRequired() > multiplier) {
                errorInventoryParts.add((Integer)slot);
            }
        });
        if (!slotsOverMultiplier.isEmpty() || !errorInventoryParts.isEmpty()) {
            return new UpgradeSlotChangeResult.Fail(TranslationHelper.INSTANCE.translError("remove.stack_low_multiplier", multiplier), Collections.emptySet(), slotsOverMultiplier, errorInventoryParts);
        }
        return new UpgradeSlotChangeResult.Success();
    }

    public static class Wrapper
    extends UpgradeWrapperBase<Wrapper, StackUpgradeItem> {
        protected Wrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
            super(storageWrapper, upgrade, upgradeSaveHandler);
        }

        public int getStackSizeMultiplier() {
            return ((StackUpgradeItem)this.upgradeItem).getStackSizeMultiplier();
        }

        @Override
        public boolean hideSettingsTab() {
            return true;
        }

        @Override
        public boolean canBeDisabled() {
            return false;
        }
    }
}

