/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.configured.client.screen.IBackgroundTexture;
import com.mrcrayfish.configured.client.screen.ILabelProvider;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public abstract class ListMenuScreen
extends Screen
implements IBackgroundTexture {
    public static final ResourceLocation CONFIGURED_LOGO = new ResourceLocation("configured", "textures/gui/logo.png");
    protected final Screen parent;
    protected final ResourceLocation background;
    protected final int itemHeight;
    protected EntryList list;
    protected List<Item> entries;
    protected List<FormattedCharSequence> activeTooltip;
    protected FocusedEditBox activeTextField;
    protected FocusedEditBox searchTextField;

    protected ListMenuScreen(Screen parent, Component title, ResourceLocation background, int itemHeight) {
        super(title);
        this.parent = parent;
        this.background = background;
        this.itemHeight = itemHeight;
    }

    protected void m_7856_() {
        ArrayList<Item> entries = new ArrayList<Item>();
        this.constructEntries(entries);
        this.entries = ImmutableList.copyOf(entries);
        this.list = new EntryList(this.entries);
        this.list.m_93488_(!ListMenuScreen.isPlayingGame());
        this.m_7787_((GuiEventListener)this.list);
        this.searchTextField = new FocusedEditBox(this.f_96547_, this.f_96543_ / 2 - 110, 22, 220, 20, (Component)new TextComponent("Search"));
        this.searchTextField.m_94151_(s -> {
            ScreenUtil.updateSearchTextFieldSuggestion(this.searchTextField, s, this.entries);
            this.list.m_5988_(s.isEmpty() ? this.entries : (Collection)this.entries.stream().filter(item -> !(item instanceof IIgnoreSearch) && item.getLabel().toLowerCase(Locale.ENGLISH).contains(s.toLowerCase(Locale.ENGLISH))).collect(Collectors.toList()));
            if (!s.isEmpty()) {
                this.list.m_93410_(0.0);
            }
        });
        this.m_7787_((GuiEventListener)this.searchTextField);
        ScreenUtil.updateSearchTextFieldSuggestion(this.searchTextField, "", this.entries);
    }

    protected abstract void constructEntries(List<Item> var1);

    @Override
    public ResourceLocation getBackgroundTexture() {
        return this.background;
    }

    public void setActiveTooltip(List<FormattedCharSequence> tooltip) {
        this.activeTooltip = tooltip;
    }

    protected void updateTooltip(int mouseX, int mouseY) {
        if (ScreenUtil.isMouseWithin(10, 13, 23, 23, mouseX, mouseY)) {
            this.setActiveTooltip(this.f_96541_.f_91062_.m_92923_((FormattedText)new TranslatableComponent("configured.gui.info"), 200));
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.activeTooltip = null;
        this.m_7333_(poseStack);
        this.list.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.searchTextField.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        ListMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)7, (int)0xFFFFFF);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        RenderSystem.m_157456_((int)0, (ResourceLocation)CONFIGURED_LOGO);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Screen.m_93143_((PoseStack)poseStack, (int)10, (int)13, (int)this.m_93252_(), (float)0.0f, (float)0.0f, (int)23, (int)23, (int)32, (int)32);
        this.updateTooltip(mouseX, mouseY);
        if (this.activeTooltip != null) {
            this.m_96617_(poseStack, this.activeTooltip, mouseX, mouseY);
        } else {
            for (GuiEventListener widget : this.m_6702_()) {
                if (!(widget instanceof Button) || !((Button)widget).m_198029_()) continue;
                ((Button)widget).m_7428_(poseStack, mouseX, mouseY);
                break;
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (ScreenUtil.isMouseWithin(10, 13, 23, 23, (int)mouseX, (int)mouseY)) {
            Style style = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/configured"));
            this.m_5561_(style);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public static boolean isPlayingGame() {
        return Minecraft.m_91087_().f_91074_ != null;
    }

    protected class EntryList
    extends ContainerObjectSelectionList<Item>
    implements IBackgroundTexture {
        public EntryList(List<Item> entries) {
            super(ListMenuScreen.this.f_96541_, ListMenuScreen.this.f_96543_, ListMenuScreen.this.f_96544_, 50, ListMenuScreen.this.f_96544_ - 36, ListMenuScreen.this.itemHeight);
            entries.forEach(x$0 -> this.m_7085_((AbstractSelectionList.Entry)x$0));
        }

        protected int m_5756_() {
            return this.f_93388_ / 2 + 144;
        }

        public int m_5759_() {
            return 260;
        }

        @Override
        public ResourceLocation getBackgroundTexture() {
            return ListMenuScreen.this.background;
        }

        public void m_5988_(Collection<Item> entries) {
            super.m_5988_(entries);
        }

        public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
            this.renderToolTips(poseStack, mouseX, mouseY);
        }

        private void renderToolTips(PoseStack poseStack, int mouseX, int mouseY) {
            Item item2;
            if (this.m_5953_(mouseX, mouseY) && mouseX < ListMenuScreen.this.list.m_5747_() + ListMenuScreen.this.list.m_5759_() - 67 && (item2 = (Item)this.m_93412_(mouseX, mouseY)) != null) {
                ListMenuScreen.this.setActiveTooltip(item2.tooltip);
            }
            this.m_6702_().forEach(item -> item.m_6702_().forEach(o -> {
                if (o instanceof Button) {
                    ((Button)o).m_7428_(poseStack, mouseX, mouseY);
                }
            }));
        }
    }

    protected class FocusedEditBox
    extends EditBox {
        public FocusedEditBox(Font font, int x, int y, int width, int height, Component label) {
            super(font, x, y, width, height, label);
        }

        protected void m_7207_(boolean focused) {
            super.m_7207_(focused);
            if (focused) {
                if (ListMenuScreen.this.activeTextField != null && ListMenuScreen.this.activeTextField != this) {
                    ListMenuScreen.this.activeTextField.m_93692_(false);
                }
                ListMenuScreen.this.activeTextField = this;
            }
        }
    }

    protected static interface IIgnoreSearch {
    }

    protected abstract class Item
    extends ContainerObjectSelectionList.Entry<Item>
    implements ILabelProvider {
        protected final Component label;
        protected List<FormattedCharSequence> tooltip;

        public Item(Component label) {
            this.label = label;
        }

        public Item(String label) {
            this.label = new TextComponent(label);
        }

        @Override
        public String getLabel() {
            return this.label.getString();
        }

        public void setTooltip(Component text, int maxWidth) {
            this.tooltip = ((ListMenuScreen)ListMenuScreen.this).f_96541_.f_91062_.m_92923_((FormattedText)text, maxWidth);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput output) {
                    output.m_169146_(NarratedElementType.TITLE, Item.this.label);
                }
            });
        }
    }

    public class SubTitleItem
    extends Item
    implements IIgnoreSearch {
        public SubTitleItem(Component title) {
            super(title);
        }

        public SubTitleItem(String title) {
            super((Component)new TextComponent(title).m_130940_(ChatFormatting.GRAY));
        }

        public void m_6311_(PoseStack poseStack, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            Screen.m_93215_((PoseStack)poseStack, (Font)((ListMenuScreen)ListMenuScreen.this).f_96541_.f_91062_, (Component)this.label, (int)(left + width / 2), (int)(top + 5), (int)0xFFFFFF);
        }
    }

    public class TitleItem
    extends Item
    implements IIgnoreSearch {
        public TitleItem(Component title) {
            super(title);
        }

        public TitleItem(String title) {
            super((Component)new TextComponent(title).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.YELLOW));
        }

        public void m_6311_(PoseStack poseStack, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            Screen.m_93215_((PoseStack)poseStack, (Font)((ListMenuScreen)ListMenuScreen.this).f_96541_.f_91062_, (Component)this.label, (int)(left + width / 2), (int)(top + 5), (int)0xFFFFFF);
        }
    }
}

