/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.ui.IElement;
import mcp.mobius.waila.api.ui.IElementHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ComparatorBlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ComparatorMode;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import snownee.jade.VanillaPlugin;

public class VanillaProvider
implements IComponentProvider,
IServerDataProvider<BlockEntity> {
    public static final VanillaProvider INSTANCE = new VanillaProvider();
    static final ResourceLocation OBJECT_NAME_TAG = new ResourceLocation("waila", "object_name");

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IElement getIcon(BlockAccessor accessor, IPluginConfig config, IElement currentIcon) {
        if (accessor.getBlock() == Blocks.f_50092_) {
            return VanillaPlugin.getElementHelper().item(new ItemStack((ItemLike)Items.f_42405_));
        }
        if (accessor.getBlock() == Blocks.f_50444_) {
            return VanillaPlugin.getElementHelper().item(new ItemStack((ItemLike)Items.f_42732_));
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHead(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (accessor.getBlock() == Blocks.f_50085_ && config.get(VanillaPlugin.SPAWNER_TYPE)) {
            SpawnerBlockEntity spawner = (SpawnerBlockEntity)accessor.getBlockEntity();
            String name = I18n.m_118938_((String)accessor.getBlock().m_7705_(), (Object[])new Object[0]);
            Entity entity = spawner.m_59801_().m_151314_(accessor.getLevel());
            if (entity != null) {
                name = I18n.m_118938_((String)"jade.spawner", (Object[])new Object[]{name, entity.m_5446_().getString()});
                name = String.format(config.getWailaConfig().getFormatting().getBlockName(), name);
                tooltip.remove(OBJECT_NAME_TAG);
                tooltip.add((Component)new TextComponent(name).m_130948_(config.getWailaConfig().getOverlay().getColor().getTitle()), OBJECT_NAME_TAG);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        ItemStack stack;
        if (accessor.getTooltipPosition() == TooltipPosition.HEAD) {
            this.appendHead(tooltip, accessor, config);
            return;
        }
        BlockState state = accessor.getBlockState();
        Block block = state.m_60734_();
        if (config.get(VanillaPlugin.CROP_PROGRESS)) {
            if (block instanceof CropBlock) {
                CropBlock crop = (CropBlock)block;
                VanillaProvider.addMaturityTooltip(tooltip, (float)((Integer)state.m_61143_((Property)crop.m_7959_())).intValue() / (float)crop.m_7419_());
            } else if (state.m_61138_((Property)BlockStateProperties.f_61409_)) {
                VanillaProvider.addMaturityTooltip(tooltip, (float)((Integer)state.m_61143_((Property)BlockStateProperties.f_61409_)).intValue() / 7.0f);
            } else if (state.m_61138_((Property)BlockStateProperties.f_61406_)) {
                VanillaProvider.addMaturityTooltip(tooltip, (float)((Integer)state.m_61143_((Property)BlockStateProperties.f_61406_)).intValue() / 2.0f);
            } else if (state.m_61138_((Property)BlockStateProperties.f_61407_) && (block instanceof SweetBerryBushBlock || block instanceof NetherWartBlock)) {
                VanillaProvider.addMaturityTooltip(tooltip, (float)((Integer)state.m_61143_((Property)BlockStateProperties.f_61407_)).intValue() / 3.0f);
            }
        }
        if (config.get(VanillaPlugin.REDSTONE)) {
            this.appendRedstone(tooltip, state, accessor.getServerData());
        }
        if (config.get(VanillaPlugin.JUKEBOX) && block instanceof JukeboxBlock) {
            if (((Boolean)state.m_61143_((Property)JukeboxBlock.f_54254_)).booleanValue() && accessor.getServerData().m_128441_("record")) {
                try {
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(accessor.getServerData().m_128461_("record")));
                    if (item instanceof RecordItem) {
                        tooltip.add((Component)new TranslatableComponent("record.nowPlaying", new Object[]{((RecordItem)item).m_43050_()}));
                    }
                }
                catch (Exception e) {
                    Waila.LOGGER.catching((Throwable)e);
                }
            } else {
                tooltip.add((Component)new TranslatableComponent("tooltip.waila.empty"));
            }
        }
        if (config.get(VanillaPlugin.LECTERN) && block instanceof LecternBlock && ((Boolean)state.m_61143_((Property)LecternBlock.f_54467_)).booleanValue() && accessor.getServerData().m_128441_("book") && !(stack = ItemStack.m_41712_((CompoundTag)accessor.getServerData().m_128469_("book"))).m_41619_()) {
            IElementHelper helper = tooltip.getElementHelper();
            tooltip.add(helper.item(stack, 0.75f));
            tooltip.append(helper.text(stack.m_41786_()).translate(new Vec2(3.0f, 3.0f)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void appendRedstone(ITooltip tooltip, BlockState state, CompoundTag serverData) {
        Block block = state.m_60734_();
        if (block instanceof LeverBlock) {
            boolean active = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_);
            tooltip.add((Component)new TranslatableComponent("tooltip.waila.state", new Object[]{new TranslatableComponent("tooltip.waila.state_" + (active ? "on" : "off"))}));
            return;
        }
        if (block == Blocks.f_50146_) {
            int delay = (Integer)state.m_61143_((Property)BlockStateProperties.f_61413_);
            tooltip.add((Component)new TranslatableComponent("tooltip.waila.delay", new Object[]{ChatFormatting.WHITE.toString() + delay}));
            return;
        }
        if (block == Blocks.f_50328_) {
            ComparatorMode mode = (ComparatorMode)state.m_61143_((Property)BlockStateProperties.f_61393_);
            tooltip.add((Component)new TranslatableComponent("tooltip.waila.mode", new Object[]{new TranslatableComponent("tooltip.waila.mode_" + (mode == ComparatorMode.COMPARE ? "comparator" : "subtractor")).m_130940_(ChatFormatting.WHITE)}));
            if (serverData.m_128441_("signal")) {
                tooltip.add((Component)new TranslatableComponent("tooltip.waila.power", new Object[]{ChatFormatting.WHITE.toString() + serverData.m_128451_("signal")}));
            }
            return;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61426_)) {
            tooltip.add((Component)new TranslatableComponent("tooltip.waila.power", new Object[]{ChatFormatting.WHITE.toString() + state.m_61143_((Property)BlockStateProperties.f_61426_)}));
        }
    }

    @Override
    public void appendServerData(CompoundTag data, ServerPlayer player, Level world, BlockEntity blockEntity, boolean showDetails) {
        LecternBlockEntity lectern;
        JukeboxBlockEntity jukebox;
        ItemStack stack;
        if (blockEntity instanceof JukeboxBlockEntity && !(stack = (jukebox = (JukeboxBlockEntity)blockEntity).m_59524_()).m_41619_()) {
            data.m_128359_("record", stack.m_41720_().getRegistryName().toString());
        }
        if (blockEntity instanceof LecternBlockEntity && !(stack = (lectern = (LecternBlockEntity)blockEntity).m_59566_()).m_41619_() && (stack.m_41788_() || stack.m_41720_() != Items.f_42614_)) {
            data.m_128365_("book", (Tag)stack.serializeNBT());
        }
        if (blockEntity instanceof ComparatorBlockEntity) {
            ComparatorBlockEntity comparator = (ComparatorBlockEntity)blockEntity;
            data.m_128405_("signal", comparator.m_59182_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void addMaturityTooltip(ITooltip tooltip, float growthValue) {
        if ((growthValue *= 100.0f) < 100.0f) {
            tooltip.add((Component)new TranslatableComponent("tooltip.waila.crop_growth", new Object[]{String.format("%.0f%%", Float.valueOf(growthValue))}));
        } else {
            tooltip.add((Component)new TranslatableComponent("tooltip.waila.crop_growth", new Object[]{new TranslatableComponent("tooltip.waila.crop_mature").m_130940_(ChatFormatting.GREEN)}));
        }
    }
}

