/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.ui.IBorderStyle;
import mcp.mobius.waila.api.ui.IDisplayHelper;
import mcp.mobius.waila.impl.ui.BorderStyle;
import mcp.mobius.waila.overlay.IconUI;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class DisplayHelper
implements IDisplayHelper {
    public static final DisplayHelper INSTANCE = new DisplayHelper();
    private static final Vector3f DIFFUSE_LIGHT_0 = new Vector3f(-0.5f, -0.1f, -0.1f);
    private static final Vector3f DIFFUSE_LIGHT_1 = new Vector3f(0.0f, -1.0f, 0.0f);
    private static final Minecraft CLIENT = Minecraft.m_91087_();
    private static float blitOffset;
    private static final int TEX_WIDTH = 16;
    private static final int TEX_HEIGHT = 16;
    private static final int MIN_FLUID_HEIGHT = 1;
    public static DecimalFormat dfCommas;

    @Override
    public void drawItem(PoseStack matrixStack, float x, float y, ItemStack stack, float scale, @Nullable String text) {
        matrixStack.m_85836_();
        RenderSystem.m_69482_();
        try {
            DisplayHelper.tryRenderGuiItem(matrixStack, stack, x, y, scale);
            DisplayHelper.renderGuiItemDecorations(matrixStack, DisplayHelper.CLIENT.f_91062_, stack, x, y, text);
        }
        catch (Exception e) {
            String stackStr = stack != null ? stack.toString() : "NullStack";
            WailaExceptionHandler.handleErr(e, "drawItem | " + stackStr, null);
        }
        RenderSystem.m_69465_();
        matrixStack.m_85849_();
    }

    private static void renderGuiItemDecorations(PoseStack posestack, Font font, ItemStack stack, float p_115177_, float p_115178_, @Nullable String p_115179_) {
        LocalPlayer localplayer;
        float f;
        if (stack.m_41619_()) {
            return;
        }
        ItemRenderer renderer = CLIENT.m_91291_();
        if (stack.m_41613_() != 1 || p_115179_ != null) {
            String s = p_115179_ == null ? String.valueOf(stack.m_41613_()) : p_115179_;
            posestack.m_85837_(0.0, 0.0, (double)(renderer.f_115093_ + 200.0f));
            MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            font.m_92811_(s, p_115177_ + 19.0f - 2.0f - (float)font.m_92895_(s), p_115178_ + 6.0f + 3.0f, 0xFFFFFF, true, posestack.m_85850_().m_85861_(), (MultiBufferSource)multibuffersource$buffersource, false, 0, 0xF000F0);
            multibuffersource$buffersource.m_109911_();
        }
        if (stack.m_150947_()) {
            RenderSystem.m_69465_();
            RenderSystem.m_69472_();
            RenderSystem.m_69461_();
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            double health = stack.m_150948_();
            int i = Math.round(13.0f - (float)health * 13.0f);
            int j = stack.m_150949_();
            DisplayHelper.draw(posestack, bufferbuilder, p_115177_ + 2.0f, p_115178_ + 13.0f, 13, 2, 0, 0, 0, 255);
            DisplayHelper.draw(posestack, bufferbuilder, p_115177_ + 2.0f, p_115178_ + 13.0f, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
            RenderSystem.m_69478_();
            RenderSystem.m_69493_();
            RenderSystem.m_69482_();
        }
        float f2 = f = (localplayer = Minecraft.m_91087_().f_91074_) == null ? 0.0f : localplayer.m_36335_().m_41521_(stack.m_41720_(), Minecraft.m_91087_().m_91296_());
        if (f > 0.0f) {
            RenderSystem.m_69465_();
            RenderSystem.m_69472_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            Tesselator tesselator1 = Tesselator.m_85913_();
            BufferBuilder bufferbuilder1 = tesselator1.m_85915_();
            DisplayHelper.draw(posestack, bufferbuilder1, p_115177_, p_115178_ + (float)Mth.m_14143_((float)(16.0f * (1.0f - f))), 16, Mth.m_14167_((float)(16.0f * f)), 255, 255, 255, 127);
            RenderSystem.m_69493_();
            RenderSystem.m_69482_();
        }
    }

    private static void draw(PoseStack ms, BufferBuilder renderer, float x, float y, int width, int height, int red, int green, int blue, int alpha) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Matrix4f matrix = ms.m_85850_().m_85861_();
        renderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        renderer.m_85982_(matrix, x, y, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_85982_(matrix, x, y + (float)height, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_85982_(matrix, x + (float)width, y + (float)height, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_85982_(matrix, x + (float)width, y, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)renderer);
    }

    public static void tryRenderGuiItem(PoseStack matrixStack, ItemStack stack, float x, float y, float scale) {
        ItemRenderer renderer = CLIENT.m_91291_();
        DisplayHelper.renderGuiItem(matrixStack, stack, x, y, renderer.m_174264_(stack, null, null, 0), scale);
    }

    private static void renderGuiItem(PoseStack posestack, ItemStack p_115128_, float p_115129_, float p_115130_, BakedModel p_115131_, float scale) {
        boolean flag;
        ItemRenderer renderer = CLIENT.m_91291_();
        TextureManager textureManager = DisplayHelper.CLIENT.f_90987_;
        textureManager.m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        posestack.m_85836_();
        RenderSystem.m_157450_((Vector3f)DIFFUSE_LIGHT_0, (Vector3f)DIFFUSE_LIGHT_1);
        posestack.m_85837_((double)p_115129_, (double)p_115130_, (double)(150.0f + blitOffset));
        posestack.m_85837_(8.0 * (double)scale, 8.0 * (double)scale, 0.0);
        posestack.m_85841_(scale, -scale, scale);
        posestack.m_85841_(16.0f, 16.0f, 16.0f);
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = flag = !p_115131_.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        }
        renderer.m_115143_(p_115128_, ItemTransforms.TransformType.GUI, false, posestack, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0, OverlayTexture.f_118083_, p_115131_);
        multibuffersource$buffersource.m_109911_();
        RenderSystem.m_69482_();
        Lighting.m_84931_();
        posestack.m_85849_();
    }

    @Override
    public void drawGradientRect(PoseStack matrixStack, float left, float top, float right, float bottom, int startColor, int endColor) {
        this.drawGradientRect(matrixStack, left, top, right, bottom, startColor, endColor, false);
    }

    public void drawGradientRect(PoseStack matrixStack, float left, float top, float right, float bottom, int startColor, int endColor, boolean vertical) {
        float zLevel = 0.0f;
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        if (vertical) {
            buffer.m_85982_(matrix, left + right, top, zLevel).m_85950_(f5, f6, f7, f4).m_5752_();
            buffer.m_85982_(matrix, left, top, zLevel).m_85950_(f1, f2, f3, f).m_5752_();
            buffer.m_85982_(matrix, left, top + bottom, zLevel).m_85950_(f1, f2, f3, f).m_5752_();
            buffer.m_85982_(matrix, left + right, top + bottom, zLevel).m_85950_(f5, f6, f7, f4).m_5752_();
        } else {
            buffer.m_85982_(matrix, left + right, top, zLevel).m_85950_(f1, f2, f3, f).m_5752_();
            buffer.m_85982_(matrix, left, top, zLevel).m_85950_(f1, f2, f3, f).m_5752_();
            buffer.m_85982_(matrix, left, top + bottom, zLevel).m_85950_(f5, f6, f7, f4).m_5752_();
            buffer.m_85982_(matrix, left + right, top + bottom, zLevel).m_85950_(f5, f6, f7, f4).m_5752_();
        }
        tessellator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    @Override
    public void drawBorder(PoseStack matrixStack, float minX, float minY, float maxX, float maxY, IBorderStyle border0) {
        BorderStyle border = (BorderStyle)border0;
        DisplayHelper.fill(matrixStack, minX + (float)border.width, minY, maxX - (float)border.width, minY + (float)border.width, border.color);
        DisplayHelper.fill(matrixStack, minX + (float)border.width, maxY - (float)border.width, maxX - (float)border.width, maxY, border.color);
        DisplayHelper.fill(matrixStack, minX, minY, minX + (float)border.width, maxY, border.color);
        DisplayHelper.fill(matrixStack, maxX - (float)border.width, minY, maxX, maxY, border.color);
    }

    public static void drawTexturedModalRect(PoseStack matrixStack, float x, float y, int textureX, int textureY, int width, int height, int tw, int th) {
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        float zLevel = 0.0f;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_85982_(matrix, x, y + (float)height, zLevel).m_7421_((float)textureX * f, (float)(textureY + th) * f1).m_5752_();
        buffer.m_85982_(matrix, x + (float)width, y + (float)height, zLevel).m_7421_((float)(textureX + tw) * f, (float)(textureY + th) * f1).m_5752_();
        buffer.m_85982_(matrix, x + (float)width, y, zLevel).m_7421_((float)(textureX + tw) * f, (float)textureY * f1).m_5752_();
        buffer.m_85982_(matrix, x, y, zLevel).m_7421_((float)textureX * f, (float)textureY * f1).m_5752_();
        tessellator.m_85914_();
    }

    public static List<Component> itemDisplayNameMultiline(ItemStack itemstack) {
        ArrayList<Component> namelist = null;
        try {
            namelist = itemstack.m_41651_((Player)DisplayHelper.CLIENT.f_91074_, (TooltipFlag)TooltipFlag.Default.NORMAL);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (namelist == null) {
            namelist = new ArrayList<Component>();
        }
        if (namelist.isEmpty()) {
            namelist.add((Component)new TextComponent("Unnamed"));
        }
        namelist.set(0, (Component)new TextComponent(itemstack.m_41791_().f_43022_.toString() + namelist.get(0)));
        for (int i = 1; i < namelist.size(); ++i) {
            namelist.set(i, (Component)namelist.get(i));
        }
        return namelist;
    }

    public static void renderIcon(PoseStack matrixStack, float x, float y, int sx, int sy, IconUI icon) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
        if (icon == null) {
            return;
        }
        if (icon.bu != -1) {
            DisplayHelper.drawTexturedModalRect(matrixStack, x, y, icon.bu, icon.bv, sx, sy, icon.bsu, icon.bsv);
        }
        DisplayHelper.drawTexturedModalRect(matrixStack, x, y, icon.u, icon.v, sx, sy, icon.su, icon.sv);
    }

    public void drawFluid(PoseStack matrixStack, float xPosition, float yPosition, @Nullable FluidStack fluidStack, float width, float height, int capacityMb) {
        if (fluidStack == null || fluidStack.isEmpty()) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return;
        }
        TextureAtlasSprite fluidStillSprite = DisplayHelper.getStillFluidSprite(fluidStack);
        FluidAttributes attributes = fluid.getAttributes();
        int fluidColor = attributes.getColor(fluidStack);
        int amount = fluidStack.getAmount();
        float scaledAmount = (float)amount * height / (float)capacityMb;
        if (amount > 0 && scaledAmount < 1.0f) {
            scaledAmount = 1.0f;
        }
        if (scaledAmount > height) {
            scaledAmount = height;
        }
        this.drawTiledSprite(matrixStack, xPosition, yPosition, width, height, fluidColor, scaledAmount, fluidStillSprite);
    }

    private void drawTiledSprite(PoseStack matrixStack, float xPosition, float yPosition, float tiledWidth, float tiledHeight, int color, float scaledAmount, TextureAtlasSprite sprite) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        DisplayHelper.setGLColorFromInt(color);
        int xTileCount = (int)(tiledWidth / 16.0f);
        float xRemainder = tiledWidth - (float)(xTileCount * 16);
        int yTileCount = (int)(scaledAmount / 16.0f);
        float yRemainder = scaledAmount - (float)(yTileCount * 16);
        float yStart = yPosition + tiledHeight;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                float width = xTile == xTileCount ? xRemainder : 16.0f;
                float height = yTile == yTileCount ? yRemainder : 16.0f;
                float x = xPosition + (float)(xTile * 16);
                float y = yStart - (float)((yTile + 1) * 16);
                if (!(width > 0.0f) || !(height > 0.0f)) continue;
                float maskTop = 16.0f - height;
                float maskRight = 16.0f - width;
                DisplayHelper.drawTextureWithMasking(matrix, x, y, sprite, maskTop, maskRight, 100.0f);
            }
        }
    }

    private static TextureAtlasSprite getStillFluidSprite(FluidStack fluidStack) {
        Minecraft minecraft = Minecraft.m_91087_();
        Fluid fluid = fluidStack.getFluid();
        FluidAttributes attributes = fluid.getAttributes();
        ResourceLocation fluidStill = attributes.getStillTexture(fluidStack);
        return (TextureAtlasSprite)minecraft.m_91258_(InventoryMenu.f_39692_).apply(fluidStill);
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)alpha);
    }

    private static void drawTextureWithMasking(Matrix4f matrix, float xCoord, float yCoord, TextureAtlasSprite textureSprite, float maskTop, float maskRight, float zLevel) {
        float uMin = textureSprite.m_118409_();
        float uMax = textureSprite.m_118410_();
        float vMin = textureSprite.m_118411_();
        float vMax = textureSprite.m_118412_();
        uMax -= maskRight / 16.0f * (uMax - uMin);
        vMax -= maskTop / 16.0f * (vMax - vMin);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_85982_(matrix, xCoord, yCoord + 16.0f, zLevel).m_7421_(uMin, vMax).m_5752_();
        bufferBuilder.m_85982_(matrix, xCoord + 16.0f - maskRight, yCoord + 16.0f, zLevel).m_7421_(uMax, vMax).m_5752_();
        bufferBuilder.m_85982_(matrix, xCoord + 16.0f - maskRight, yCoord + maskTop, zLevel).m_7421_(uMax, vMin).m_5752_();
        bufferBuilder.m_85982_(matrix, xCoord, yCoord + maskTop, zLevel).m_7421_(uMin, vMin).m_5752_();
        tessellator.m_85914_();
    }

    public static void fill(PoseStack matrixStack, float minX, float minY, float maxX, float maxY, int color) {
        DisplayHelper.fill(matrixStack.m_85850_().m_85861_(), minX, minY, maxX, maxY, color);
    }

    private static void fill(Matrix4f matrix, float minX, float minY, float maxX, float maxY, int color) {
        if (minX < maxX) {
            float i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            float j = minY;
            minY = maxY;
            maxY = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_85982_(matrix, minX, maxY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_85982_(matrix, maxX, maxY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_85982_(matrix, maxX, minY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_85982_(matrix, minX, minY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }

    @Override
    public String humanReadableNumber(double number, String unit, boolean milli) {
        boolean n;
        StringBuilder sb = new StringBuilder();
        boolean bl = n = number < 0.0;
        if (n) {
            number = -number;
            sb.append('-');
        }
        if (milli && number >= 1000.0) {
            number /= 1000.0;
            milli = false;
        }
        if (number < 1000.0) {
            sb.append(dfCommas.format(number));
            if (milli) {
                sb.append('m');
            }
        } else {
            int exp = (int)(Math.log10(number) / 3.0);
            if (exp > 7) {
                exp = 7;
            }
            char pre = "kMGTPEZ".charAt(exp - 1);
            sb.append(dfCommas.format(number / Math.pow(1000.0, exp)));
            sb.append(pre);
        }
        sb.append(unit);
        return sb.toString();
    }

    @Override
    public void drawText(PoseStack poseStack, String text, float x, float y, int color) {
        boolean shadow = Waila.CONFIG.get().getOverlay().getColor().getTheme().textShadow;
        if (shadow) {
            DisplayHelper.CLIENT.f_91062_.m_92750_(poseStack, text, x, y, color);
        } else {
            DisplayHelper.CLIENT.f_91062_.m_92883_(poseStack, text, x, y, color);
        }
    }

    @Override
    public void drawText(PoseStack poseStack, Component text, float x, float y, int color) {
        boolean shadow = Waila.CONFIG.get().getOverlay().getColor().getTheme().textShadow;
        if (shadow) {
            DisplayHelper.CLIENT.f_91062_.m_92763_(poseStack, text, x, y, color);
        } else {
            DisplayHelper.CLIENT.f_91062_.m_92889_(poseStack, text, x, y, color);
        }
    }

    static {
        dfCommas = new DecimalFormat("##.##");
        dfCommas.setRoundingMode(RoundingMode.DOWN);
    }
}

