/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.impl.ui;

import com.mojang.blaze3d.vertex.PoseStack;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.config.WailaConfig;
import mcp.mobius.waila.api.ui.Element;
import mcp.mobius.waila.overlay.DisplayHelper;
import mcp.mobius.waila.overlay.IconUI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;

public class HealthElement
extends Element {
    private final float maxHealth;
    private final float health;
    private String text;

    public HealthElement(float maxHealth, float health) {
        this.maxHealth = maxHealth;
        this.health = health;
        this.text = String.format("  %s/%s", DisplayHelper.dfCommas.format(health), DisplayHelper.dfCommas.format(maxHealth));
    }

    @Override
    public Vec2 getSize() {
        WailaConfig.ConfigGeneral config = Waila.CONFIG.get().getGeneral();
        if (this.maxHealth > (float)config.getMaxHealthForRender()) {
            Font font = Minecraft.m_91087_().f_91062_;
            return new Vec2((float)(8 + font.m_92895_(this.text)), 10.0f);
        }
        float maxHearts = config.getMaxHeartsPerLine();
        float maxHealth = this.maxHealth * 0.5f;
        int heartsPerLine = (int)Math.min((double)maxHearts, Math.ceil(maxHealth));
        int lineCount = (int)Math.ceil(maxHealth / maxHearts);
        return new Vec2((float)(8 * heartsPerLine), (float)(10 * lineCount));
    }

    @Override
    public void render(PoseStack matrixStack, float x, float y, float maxX, float maxY) {
        WailaConfig.ConfigGeneral config = Waila.CONFIG.get().getGeneral();
        float maxHearts = config.getMaxHeartsPerLine();
        int heartCount = this.maxHealth > (float)config.getMaxHealthForRender() ? 1 : Mth.m_14167_((float)(this.maxHealth * 0.5f));
        float health = this.maxHealth > (float)config.getMaxHealthForRender() ? 1.0f : this.health * 0.5f;
        int heartsPerLine = (int)Math.min((double)maxHearts, Math.ceil(this.maxHealth));
        int xOffset = 0;
        for (int i = 1; i <= heartCount; ++i) {
            if (i <= Mth.m_14143_((float)health)) {
                DisplayHelper.renderIcon(matrixStack, x + (float)xOffset, y, 8, 8, IconUI.HEART);
                xOffset += 8;
            }
            if ((float)i > health && (float)i < health + 1.0f) {
                DisplayHelper.renderIcon(matrixStack, x + (float)xOffset, y, 8, 8, IconUI.HALF_HEART);
                xOffset += 8;
            }
            if ((float)i >= health + 1.0f) {
                DisplayHelper.renderIcon(matrixStack, x + (float)xOffset, y, 8, 8, IconUI.EMPTY_HEART);
                xOffset += 8;
            }
            if (i % heartsPerLine != 0) continue;
            y += 10.0f;
            xOffset = 0;
        }
        if (this.maxHealth > (float)config.getMaxHealthForRender()) {
            WailaConfig.ConfigOverlay.ConfigOverlayColor color = Waila.CONFIG.get().getOverlay().getColor();
            DisplayHelper.INSTANCE.drawText(matrixStack, this.text, x + 8.0f, y, color.getTheme().textColor);
        }
    }

    @Override
    @Nullable
    public Component getMessage() {
        return new TranslatableComponent("narration.waila.health", new Object[]{DisplayHelper.dfCommas.format(this.health)});
    }
}

