/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.util;

import ht.treechop.common.util.Chop;
import ht.treechop.common.util.ChopUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.util.FakePlayerFactory;

public class ChopResult {
    public static final ChopResult IGNORED = new ChopResult(null, Collections.emptyList(), Collections.emptyList());
    private final Level level;
    private final Collection<Chop> chops;
    private final Collection<BlockPos> fells;
    private final boolean felling;
    public static final int MAX_NUM_FELLING_EFFECTS = 32;

    public ChopResult(Level level, Collection<Chop> chops, Collection<BlockPos> fells) {
        this.level = level;
        this.chops = chops;
        this.fells = fells;
        this.felling = !fells.isEmpty();
    }

    public boolean apply(BlockPos targetPos, ServerPlayer agent, ItemStack tool, boolean breakLeaves) {
        GameType gameType = agent.f_8941_.m_9290_();
        AtomicBoolean somethingChanged = new AtomicBoolean(false);
        List<BlockPos> logs = Stream.concat(this.chops.stream().map(Chop::getBlockPos), this.fells.stream()).filter(pos -> !somethingChanged.get() && ChopUtil.canChangeBlock(this.level, pos, (Player)agent, gameType, tool)).peek(pos -> {
            BlockState blockState = this.level.m_8055_(pos);
            somethingChanged.compareAndSet(false, blockState.m_60795_());
        }).collect(Collectors.toList());
        if (somethingChanged.get()) {
            return false;
        }
        this.chopBlocks(this.level, (Player)agent, tool, this.chops.stream());
        if (this.felling) {
            List<BlockPos> leaves = breakLeaves ? ChopUtil.getTreeLeaves(this.level, logs).stream().filter(pos -> ChopUtil.canChangeBlock(this.level, pos, (Player)agent, agent.f_8941_.m_9290_())).collect(Collectors.toList()) : Collections.emptyList();
            logs.remove(targetPos);
            this.playBlockBreakEffects(this.level, logs, leaves);
            this.fells.remove(targetPos);
            this.fellBlocks(this.level, targetPos, agent, Stream.of(this.fells, leaves).flatMap(Collection::stream));
            return false;
        }
        return true;
    }

    private void chopBlocks(Level level, Player player, ItemStack tool, Stream<Chop> chops) {
        chops.forEach(chop -> chop.apply(level, player, tool, this.felling));
    }

    private void fellBlocks(Level level, BlockPos targetPos, ServerPlayer agent, Stream<BlockPos> blocks) {
        Consumer<BlockPos> blockBreaker;
        ServerPlayer fakePlayer = level instanceof ServerLevel ? FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)level)) : agent;
        AtomicInteger xpAccumulator = new AtomicInteger(0);
        if (level.m_5776_() || agent.m_7500_()) {
            BlockState air = Blocks.f_50016_.m_49966_();
            blockBreaker = pos -> level.m_7731_(pos, air, 3);
        } else {
            blockBreaker = arg_0 -> ChopResult.lambda$fellBlocks$5((Player)fakePlayer, level, xpAccumulator, arg_0);
        }
        blocks.forEach(blockBreaker);
        ChopUtil.dropExperience(level, targetPos, xpAccumulator.get());
    }

    private void playBlockBreakEffects(Level level, List<BlockPos> logs, List<BlockPos> leaves) {
        int numLogsAndLeaves = logs.size() + leaves.size();
        int numEffects = Math.min((int)Math.ceil(Math.sqrt(numLogsAndLeaves)), 32) - 1;
        int numLeavesEffects = Math.max(1, (int)Math.ceil((double)numEffects * ((double)leaves.size() / (double)numLogsAndLeaves)));
        int numLogsEffects = Math.max(1, numEffects - numLeavesEffects);
        Collections.shuffle(logs);
        Collections.shuffle(leaves);
        Stream.concat(logs.stream().limit(numLogsEffects), leaves.stream().limit(numLeavesEffects)).forEach(pos -> level.m_46796_(2001, pos, Block.m_49956_((BlockState)level.m_8055_(pos))));
    }

    private static void harvestWorldBlock(Player agent, Level level, BlockPos pos, ItemStack tool, AtomicInteger totalXp, int fortune, int silkTouch) {
        BlockState blockState = level.m_8055_(pos);
        if (level instanceof ServerLevel) {
            FluidState fluidStateOrAir = level.m_6425_(pos);
            blockState.m_60734_().m_6786_((LevelAccessor)level, pos, blockState);
            Block.m_49881_((BlockState)blockState, (Level)level, (BlockPos)pos, (BlockEntity)level.m_7702_(pos), (Entity)agent, (ItemStack)tool);
            totalXp.getAndAdd(blockState.getExpDrop((LevelReader)level, pos, fortune, silkTouch));
            level.m_7731_(pos, fluidStateOrAir.m_76188_(), 3);
        }
    }

    public boolean isFelling() {
        return this.fells.size() > 0;
    }

    private static /* synthetic */ void lambda$fellBlocks$5(Player fakePlayer, Level level, AtomicInteger xpAccumulator, BlockPos pos) {
        ChopResult.harvestWorldBlock(fakePlayer, level, pos, ItemStack.f_41583_, xpAccumulator, 0, 0);
    }
}

