/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.util;

import ht.treechop.TreeChopMod;
import ht.treechop.api.IChoppableBlock;
import ht.treechop.common.util.ChopUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class Chop {
    private final BlockPos blockPos;
    private final int numChops;

    public Chop(BlockPos blockPos, int numChops) {
        this.blockPos = blockPos;
        this.numChops = numChops;
    }

    public int getNumChops() {
        return this.numChops;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public void apply(Level level, Player player, ItemStack tool, boolean felling) {
        BlockState blockState = level.m_8055_(this.blockPos);
        Block block = ChopUtil.getChoppedBlock(blockState);
        if (block instanceof IChoppableBlock) {
            IChoppableBlock choppableBlock = (IChoppableBlock)block;
            choppableBlock.chop(player, tool, level, this.blockPos, blockState, this.numChops, felling);
        } else {
            TreeChopMod.LOGGER.warn("Failed to chop block in level {} at position {} for player {}: {} does not implement IChoppableBlock", new Object[]{level.m_46472_(), this.blockPos, player.m_7755_(), blockState.m_60734_().getRegistryName()});
        }
    }
}

