/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.settings;

import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;

public enum SneakBehavior implements StringRepresentable
{
    NONE("treechop.sneak_behavior.none", agent -> false, agent -> false),
    INVERT_CHOPPING("treechop.sneak_behavior.invert_chopping", Entity::m_6144_, agent -> false),
    INVERT_FELLING("treechop.sneak_behavior.invert_felling", agent -> false, Entity::m_6144_);

    public static final int maxNameLength;
    private final Predicate<Entity> chopBehavior;
    private final Predicate<Entity> fellBehavior;
    private final String langKey;

    private SneakBehavior(String langKey, Predicate<Entity> chopBehavior, Predicate<Entity> fellBehavior) {
        this.chopBehavior = chopBehavior;
        this.fellBehavior = fellBehavior;
        this.langKey = langKey;
    }

    public SneakBehavior cycle() {
        return SneakBehavior.values()[Math.floorMod(this.ordinal() + 1, SneakBehavior.values().length)];
    }

    public String toString() {
        return this.name();
    }

    public String m_7912_() {
        return this.name();
    }

    public boolean shouldChangeChopBehavior(Entity agent) {
        return this.chopBehavior.test(agent);
    }

    public boolean shouldChangeFellBehavior(Entity agent) {
        return this.fellBehavior.test(agent);
    }

    public String getFancyText() {
        return I18n.m_118938_((String)this.langKey, (Object[])new Object[0]);
    }

    static {
        maxNameLength = Arrays.stream(SneakBehavior.values()).map(Enum::name).map(String::length).max(Integer::compareTo).orElse(0);
    }
}

