/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.capabilities;

import ht.treechop.TreeChopMod;
import ht.treechop.common.capabilities.ChopSettingsCapability;
import ht.treechop.common.settings.ChopSettings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class ChopSettingsProvider
implements ICapabilitySerializable<Tag> {
    private final ChopSettingsCapability chopSettings = new ChopSettingsCapability();
    private final LazyOptional<ChopSettingsCapability> lazyChopSettings = LazyOptional.of(() -> this.chopSettings);

    public ChopSettingsProvider() {
    }

    public ChopSettingsProvider(ChopSettings defaults) {
        this.chopSettings.copyFrom(defaults);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        return ChopSettingsCapability.CAPABILITY == capability ? this.lazyChopSettings.cast() : LazyOptional.empty();
    }

    private ChopSettingsCapability getLazyChopSettings() {
        return (ChopSettingsCapability)this.lazyChopSettings.orElseThrow(() -> new IllegalArgumentException("LazyOptional must not be empty"));
    }

    public Tag serializeNBT() {
        return this.getLazyChopSettings().serializeNBT();
    }

    public void deserializeNBT(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            this.getLazyChopSettings().deserializeNBT((CompoundTag)nbt);
        } else {
            TreeChopMod.LOGGER.warn("Bad ChopSettings tag type: " + nbt);
        }
    }
}

