/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.model;

import com.mojang.math.Vector3f;
import ht.treechop.common.util.FaceShape;
import ht.treechop.common.util.Vector3;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.SimpleModelState;

public class ModelUtil {
    public static BakedQuad makeQuad(TextureAtlasSprite sprite, FaceShape faceShape, Direction orientation, Direction culling) {
        return ModelUtil.makeQuad(sprite, faceShape.getCorner1(), faceShape.getCorner3(), orientation, culling);
    }

    public static BakedQuad makeQuad(TextureAtlasSprite sprite, Vector3 posFrom, Vector3 posTo, Direction orientation, Direction culling) {
        return ModelUtil.makeQuad(sprite, posFrom, posTo, orientation, culling, ModelUtil.getUVsForQuad(posFrom, posTo, orientation), 0);
    }

    private static float[] getUVsForQuad(Vector3 posFrom, Vector3 posTo, Direction orientation) {
        Vector3f posFrom3f = posFrom.asVector3f();
        Vector3f posTo3f = posTo.asVector3f();
        switch (orientation) {
            case UP: 
            case DOWN: {
                return new float[]{posFrom3f.m_122239_(), posFrom3f.m_122269_(), posTo3f.m_122239_(), posTo3f.m_122269_()};
            }
            case EAST: 
            case WEST: {
                return new float[]{posFrom3f.m_122269_(), posFrom3f.m_122260_(), posTo3f.m_122269_(), posTo3f.m_122260_()};
            }
        }
        return new float[]{posFrom3f.m_122239_(), posFrom3f.m_122260_(), posTo3f.m_122239_(), posTo3f.m_122260_()};
    }

    public static BakedQuad makeQuad(TextureAtlasSprite sprite, Vector3 posFrom, Vector3 posTo, Direction orientation, Direction culling, float[] uvs, int uvRotation) {
        return new FaceBakery().m_111600_(posFrom.asVector3f(), posTo.asVector3f(), new BlockElementFace(culling, -1, "", new BlockFaceUV(uvs, uvRotation)), sprite, orientation, (ModelState)SimpleModelState.IDENTITY, null, true, null);
    }
}

