/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.lootr;

import java.util.UUID;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.config.IPluginConfig;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import noobanidus.mods.lootr.api.blockentity.ILootBlockEntity;
import noobanidus.mods.lootr.data.DataStorage;
import snownee.jade.addon.lootr.LootrPlugin;

public enum LootrInfoProvider implements IComponentProvider,
IServerDataProvider<BlockEntity>
{
    INSTANCE;


    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (!config.get(LootrPlugin.INFO)) {
            return;
        }
        CompoundTag data = accessor.getServerData();
        int decayValue = data.m_128451_("LootrDecay");
        if (decayValue > 0) {
            tooltip.add((Component)new TranslatableComponent("jadeaddons.lootr.decay", new Object[]{decayValue / 20}));
        }
        if (data.m_128471_("LootrRefreshed")) {
            tooltip.add((Component)new TranslatableComponent("jadeaddons.lootr.refreshed"));
        } else {
            int refreshValue = data.m_128451_("LootrRefresh");
            if (refreshValue > 0) {
                tooltip.add((Component)new TranslatableComponent("jadeaddons.lootr.refresh", new Object[]{refreshValue / 20}));
            }
        }
    }

    public void appendServerData(CompoundTag data, ServerPlayer player, Level level, BlockEntity blockEntity, boolean details) {
        if (blockEntity instanceof ILootBlockEntity) {
            int decayValue;
            ILootBlockEntity tile = (ILootBlockEntity)blockEntity;
            UUID id = tile.getTileId();
            if (!DataStorage.isDecayed((UUID)id) && (decayValue = DataStorage.getDecayValue((UUID)id)) > 0) {
                data.m_128405_("LootrDecay", decayValue);
            }
            if (DataStorage.isRefreshed((UUID)id)) {
                data.m_128379_("LootrRefreshed", true);
            } else {
                int refreshValue = DataStorage.getRefreshValue((UUID)id);
                if (refreshValue > 0) {
                    data.m_128405_("LootrRefresh", refreshValue);
                }
            }
        }
    }
}

