/*
 * Decompiled with CFR 0.152.
 */
package com.vies.viescraftmachines.common.screens;

import com.vies.viescraftmachines.common.entities.machines.EntityMachineBase;
import com.vies.viescraftmachines.common.entities.machines.EntityMachineFuel;
import com.vies.viescraftmachines.common.screens.slots.SlotDisable;
import com.vies.viescraftmachines.common.screens.slots.SlotFuel;
import com.vies.viescraftmachines.common.screens.slots.SlotIgnitionKey;
import com.vies.viescraftmachines.common.screens.slots.SlotRecord;
import com.vies.viescraftmachines.common.screens.slots.SlotStorage;
import com.vies.viescraftmachines.util.init.client.InitMenuTypeVCM;
import java.awt.Color;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class MachineTypeFlyingMenu
extends AbstractContainerMenu {
    private final EntityMachineBase machine;
    private final ContainerData data;
    private final int containerRows;
    private Player interactingPlayer;
    private static int slotCount;
    public Boolean ignitionKeyWorks;
    public Boolean musicdiscWorks;
    public int offsetCalcFuelBarColors;
    public Boolean storageiteminslot1;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT;

    public MachineTypeFlyingMenu(int pContainerId, Inventory inventoryIn, FriendlyByteBuf extraData) {
        this(pContainerId, inventoryIn, inventoryIn.f_35978_.f_19853_.m_6815_(extraData.readInt()), (ContainerData)new SimpleContainerData(5));
    }

    public MachineTypeFlyingMenu(int containerIdIn, Inventory inventoryIn, Entity mountableIn, ContainerData pData) {
        super((MenuType)InitMenuTypeVCM.MACHINE_TYPE_FLYING_MAIN_MENU.get(), containerIdIn);
        this.machine = (EntityMachineBase)mountableIn;
        this.containerRows = 7;
        this.data = pData;
        this.interactingPlayer = inventoryIn.f_35978_;
        this.ignitionKeyWorks = false;
        this.musicdiscWorks = false;
        this.offsetCalcFuelBarColors = 0;
        MachineTypeFlyingMenu.m_38869_((Container)this.machine, (int)128);
        this.addPlayerInventory(inventoryIn);
        this.addPlayerHotbar(inventoryIn);
        this.machine.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
            this.m_38897_((Slot)new SlotIgnitionKey((IItemHandler)handler, 1, 39, 104));
            if (this.IsIgnitionKeyCorrect() && this.IsMachineLocked()) {
                this.ignitionKeyWorks = true;
            }
            if (this.GetMachineOwner().equals(this.GetMachineInteractingPlayer()) || this.IsIgnitionKeyCorrect() && this.IsMachineLocked() || !this.IsMachineLocked()) {
                this.m_38897_((Slot)new SlotFuel((IItemHandler)handler, 0, 134, 47));
                this.m_38897_((Slot)new SlotRecord((IItemHandler)handler, 2, 134, 90));
                this.m_38897_((Slot)new SlotStorage((IItemHandler)handler, 6, 81, 77));
            } else {
                this.m_38897_((Slot)new SlotDisable((IItemHandler)handler, 0, 600, 47));
                this.m_38897_((Slot)new SlotDisable((IItemHandler)handler, 2, 600, 90));
                this.m_38897_((Slot)new SlotDisable((IItemHandler)handler, 6, 600, 77));
            }
        });
        this.m_38884_(pData);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (index < 36) {
            if (!this.m_38903_(sourceStack, 36, 36 + TE_INVENTORY_SLOT_COUNT, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 36 + TE_INVENTORY_SLOT_COUNT) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 14 + i * 18 + this.containerRows * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 72 + this.containerRows * 18));
        }
    }

    public void m_6199_(Container p_40040_) {
        super.m_6199_(p_40040_);
    }

    public boolean m_6875_(Player p_38874_) {
        return true;
    }

    public boolean m_5882_(ItemStack p_40044_, Slot p_40045_) {
        return false;
    }

    public void m_6877_(Player p_40051_) {
        super.m_6877_(p_40051_);
    }

    public int getRowCount() {
        return this.containerRows;
    }

    public int getBurnProgressTotal() {
        EntityMachineFuel fuelmachine;
        int finalint;
        int i = this.data.m_6413_(2);
        int j = this.data.m_6413_(3);
        int n = finalint = j != 0 && i != 0 ? i * 34 / j : 0;
        if (this.machine instanceof EntityMachineFuel && !(fuelmachine = (EntityMachineFuel)this.machine).IsFuelNeeded()) {
            finalint = 34;
        }
        return finalint;
    }

    public boolean isOverallFuelLit() {
        EntityMachineFuel fuelmachine;
        Boolean fuelneeded = this.data.m_6413_(2) > 0;
        if (this.machine instanceof EntityMachineFuel && !(fuelmachine = (EntityMachineFuel)this.machine).IsFuelNeeded()) {
            return true;
        }
        return fuelneeded;
    }

    public boolean isActivelyRunning() {
        if (this.machine instanceof EntityMachineFuel) {
            EntityMachineFuel fuelmachine = (EntityMachineFuel)this.machine;
            if (!fuelmachine.IsFuelNeeded()) {
                return true;
            }
            if (fuelmachine.PoweredAndHasFuel()) {
                return true;
            }
        }
        return false;
    }

    public String CalcFuelTime() {
        String answer = "";
        long totalSecs = this.data.m_6413_(2);
        long thours = totalSecs / 3600L;
        long tminutes = totalSecs % 3600L / 60L;
        long tseconds = totalSecs % 60L;
        answer = String.format("%02d:%02d:%02d", thours, tminutes, tseconds);
        if (this.machine instanceof EntityMachineFuel) {
            EntityMachineFuel fuelmachine = (EntityMachineFuel)this.machine;
            if (fuelmachine.getStatusBroken() || this.data.m_6413_(2) == 0) {
                answer = "--:--:--";
            }
            if (!fuelmachine.IsFuelNeeded()) {
                answer = "--:--:--";
            }
        }
        return answer;
    }

    public int CalcFuelBarColors() {
        int j = this.data.m_6413_(4);
        int offset = 0;
        if (this.machine instanceof EntityMachineFuel) {
            EntityMachineFuel fuelmachine = (EntityMachineFuel)this.machine;
            if (j == 0) {
                offset = 4;
            }
            if (!fuelmachine.IsFuelNeeded()) {
                offset = 8;
            }
        }
        return offset;
    }

    public boolean IsMachinePowered() {
        EntityMachineFuel fuelmachine;
        boolean offset = false;
        if (this.machine instanceof EntityMachineFuel && (fuelmachine = (EntityMachineFuel)this.machine).getStatusPowered()) {
            offset = true;
        }
        return offset;
    }

    public String GetMachineOwner() {
        String offset = "";
        if (this.machine instanceof EntityMachineBase) {
            EntityMachineBase fuelmachine = this.machine;
            offset = fuelmachine.getStatusOwner();
        }
        return offset;
    }

    public String GetMachineInteractingPlayer() {
        return this.interactingPlayer.m_20149_();
    }

    public boolean IsMachineLocked() {
        EntityMachineFuel fuelmachine;
        boolean offset = false;
        if (this.machine instanceof EntityMachineFuel && (fuelmachine = (EntityMachineFuel)this.machine).getStatusLocked()) {
            offset = true;
        }
        return offset;
    }

    public String getMachineDurabilityActive() {
        String offset = "0";
        if (this.machine instanceof EntityMachineFuel) {
            EntityMachineFuel fuelmachine = (EntityMachineFuel)this.machine;
            offset = String.valueOf(fuelmachine.getStatusDurabilityActive());
        }
        return offset;
    }

    public String getMachineDurabilityTotal() {
        String offset = "0";
        if (this.machine instanceof EntityMachineFuel) {
            EntityMachineFuel fuelmachine = (EntityMachineFuel)this.machine;
            offset = String.valueOf(fuelmachine.getStatusDurabilityTotal());
        }
        return offset;
    }

    public String getMachineEnergyActive() {
        String offset = "0";
        if (this.machine instanceof EntityMachineFuel) {
            EntityMachineFuel fuelmachine = (EntityMachineFuel)this.machine;
            offset = String.valueOf(fuelmachine.getStatusEnergyActive());
        }
        return offset;
    }

    public String getMachineEnergyTotal() {
        String offset = "0";
        if (this.machine instanceof EntityMachineFuel) {
            EntityMachineFuel fuelmachine = (EntityMachineFuel)this.machine;
            offset = String.valueOf(fuelmachine.getStatusEnergyTotal());
        }
        return offset;
    }

    public int getMachineID() {
        return this.machine.m_142049_();
    }

    public int getMachineDurabilityActiveSpacing() {
        int offset = 0;
        if (this.machine instanceof EntityMachineFuel) {
            EntityMachineFuel fuelmachine = (EntityMachineFuel)this.machine;
            if (fuelmachine.getStatusDurabilityActive() >= 100) {
                offset = 12;
            } else if (fuelmachine.getStatusDurabilityActive() >= 10) {
                offset = 6;
            }
        }
        return offset;
    }

    public int getMachineEnergyActiveSpacing() {
        int offset = 0;
        if (this.machine instanceof EntityMachineFuel) {
            EntityMachineFuel fuelmachine = (EntityMachineFuel)this.machine;
            if (fuelmachine.getStatusEnergyActive() >= 100) {
                offset = 12;
            } else if (fuelmachine.getStatusEnergyActive() >= 10) {
                offset = 6;
            }
        }
        return offset;
    }

    public int getDurabilityTextColor() {
        int offset = Color.WHITE.getRGB();
        if (this.machine instanceof EntityMachineBase) {
            EntityMachineBase fuelmachine = this.machine;
            if (fuelmachine.getStatusDurabilityActive() >= 75) {
                offset = Color.GREEN.getRGB();
            } else if (fuelmachine.getStatusDurabilityActive() >= 50) {
                offset = Color.YELLOW.getRGB();
            } else if (fuelmachine.getStatusDurabilityActive() >= 25) {
                offset = Color.ORANGE.getRGB();
            } else if (fuelmachine.getStatusDurabilityActive() >= 0) {
                offset = Color.RED.getRGB();
            }
        }
        return offset;
    }

    public boolean getMachineBroken() {
        return this.machine.getStatusBroken();
    }

    public boolean IsIgnitionKeyCorrect() {
        this.ignitionKeyWorks = false;
        this.machine.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
            if (!handler.getStackInSlot(1).m_41619_() && handler.getStackInSlot(1).m_41782_() && handler.getStackInSlot(1).m_41783_().m_128461_("tag-machine-owner_vcm").equals(this.machine.getStatusOwner())) {
                this.ignitionKeyWorks = true;
            }
        });
        return this.ignitionKeyWorks;
    }

    public boolean IsMusicDiscCorrect() {
        this.musicdiscWorks = false;
        this.machine.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
            if (!handler.getStackInSlot(2).m_41619_() && handler.getStackInSlot(2).m_41720_() instanceof RecordItem) {
                this.musicdiscWorks = true;
            }
        });
        return this.musicdiscWorks;
    }

    public boolean IsStorageItemInSlot1() {
        this.storageiteminslot1 = false;
        this.machine.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
            if (!handler.getStackInSlot(6).m_41619_()) {
                this.storageiteminslot1 = true;
            }
        });
        return this.storageiteminslot1;
    }

    static {
        TE_INVENTORY_SLOT_COUNT = slotCount = 4;
    }
}

