/*
 * Decompiled with CFR 0.152.
 */
package com.vies.viescraftmachines.common.entities.machines;

import com.vies.viescraftmachines.common.entities.machines.EntityMachineFuel;
import com.vies.viescraftmachines.common.items.ItemDetailingKit;
import com.vies.viescraftmachines.common.items.ItemServiceDurabilityKit;
import com.vies.viescraftmachines.common.items.ItemServiceEnergyKit;
import com.vies.viescraftmachines.common.items.admintools.ItemAdminMachineBreaker;
import com.vies.viescraftmachines.common.items.admintools.ItemAdminMachineRemover;
import com.vies.viescraftmachines.common.items.admintools.ItemAdminMaxMaintenance;
import com.vies.viescraftmachines.common.items.admintools.ItemAdminOwnerEraser;
import com.vies.viescraftmachines.common.items.admintools.ItemAdminTextureShifter;
import com.vies.viescraftmachines.common.items.tools.ItemToolDismounter;
import com.vies.viescraftmachines.common.items.tools.ItemToolDismounterPlayer;
import com.vies.viescraftmachines.common.items.tools.ItemToolMachineWrench;
import com.vies.viescraftmachines.common.items.tools.ItemToolNameChanger;
import com.vies.viescraftmachines.common.items.tools.ItemToolRadioExpansion;
import com.vies.viescraftmachines.util.enums.EngineIssues;
import com.vies.viescraftmachines.util.enums.MachineTextures;
import com.vies.viescraftmachines.util.enums.TriggerEvents;
import com.vies.viescraftmachines.util.init.common.InitParticlesVCM;
import com.vies.viescraftmachines.util.init.common.InitSoundsVCM;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityMachineDurabilityAndEnergy
extends EntityMachineFuel {
    private static final EntityDataAccessor<Integer> DATA_ID_DURABILITY_ACTIVE = SynchedEntityData.m_135353_(EntityMachineDurabilityAndEnergy.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_DURABILITY_TOTAL = SynchedEntityData.m_135353_(EntityMachineDurabilityAndEnergy.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_ENERGY_ACTIVE = SynchedEntityData.m_135353_(EntityMachineDurabilityAndEnergy.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_ENERGY_TOTAL = SynchedEntityData.m_135353_(EntityMachineDurabilityAndEnergy.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_TRIGGER_EVENT = SynchedEntityData.m_135353_(EntityMachineDurabilityAndEnergy.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_ENGINE_ISSUES = SynchedEntityData.m_135353_(EntityMachineDurabilityAndEnergy.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int applydurability = 0;
    private int applyenergy = 0;
    private int baseTickDurability = 1;
    private int baseTickEnergy = 1;
    protected int tickingVariableParticle = 0;
    public int startMinorEngineIssues = 50;
    public int startMajorEngineIssues = 25;
    private int tickingVariableMinorIssues = 0;
    private int tickingVariableMajorIssues = 0;

    public EntityMachineDurabilityAndEnergy(EntityType<? extends EntityMachineDurabilityAndEnergy> entitytypeIn, Level levelIn) {
        super((EntityType<? extends EntityMachineFuel>)entitytypeIn, levelIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_DURABILITY_ACTIVE, (Object)250);
        this.f_19804_.m_135372_(DATA_ID_DURABILITY_TOTAL, (Object)250);
        this.f_19804_.m_135372_(DATA_ID_ENERGY_ACTIVE, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_ENERGY_TOTAL, (Object)250);
        this.f_19804_.m_135372_(DATA_ID_TRIGGER_EVENT, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_ENGINE_ISSUES, (Object)0);
    }

    @Override
    protected void m_7380_(CompoundTag tagIn) {
        super.m_7380_(tagIn);
        tagIn.m_128405_("tag-machine-activedurability_vcm", this.getStatusDurabilityActive());
        tagIn.m_128405_("tag-machine-totaldurability_vcm", this.getStatusDurabilityTotal());
        tagIn.m_128405_("tag-machine-activeenergy_vcm", this.getStatusEnergyActive());
        tagIn.m_128405_("tag-machine-totalenergy_vcm", this.getStatusEnergyTotal());
        tagIn.m_128405_("tag-machine-engineissues_vcm", this.getStatusEngineIssues());
    }

    @Override
    protected void m_7378_(CompoundTag tagIn) {
        super.m_7378_(tagIn);
        this.setStatusDurabilityActive(tagIn.m_128451_("tag-machine-activedurability_vcm"));
        this.setStatusDurabilityTotal(tagIn.m_128451_("tag-machine-totaldurability_vcm"));
        this.setStatusEnergyActive(tagIn.m_128451_("tag-machine-activeenergy_vcm"));
        this.setStatusEnergyTotal(tagIn.m_128451_("tag-machine-totalenergy_vcm"));
        this.setStatusEngineIssues(tagIn.m_128451_("tag-machine-engineissues_vcm"));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.MainDurabilityLogic();
        this.MainEnergyLogic();
        if (this.getStatusDurabilityActive() <= 0 && !this.getStatusBroken()) {
            this.setStatusDurabilityActive(0);
            this.setStatusEnergyActive(0);
            this.setStatusBroken(true);
            this.setStatusPowered(false);
            this.setStatusVeryBrokenCounter(this.getStatusVeryBrokenCounter() + 1);
            this.setStatusTriggerEvent(TriggerEvents.BREAK_MACHINE.ordinal());
        }
        if (!this.getStatusBroken()) {
            if (this.getStatusDurabilityActive() <= this.startMajorEngineIssues) {
                if (this.tickingVariableParticle >= 10) {
                    this.tickingVariableParticle = 0;
                    InitParticlesVCM.doBrokenEffect(this, this.f_19796_, this.f_19815_);
                }
            } else if (this.getStatusDurabilityActive() <= this.startMinorEngineIssues && this.tickingVariableParticle >= 20) {
                this.tickingVariableParticle = 0;
                InitParticlesVCM.doBrokenEffect(this, this.f_19796_, this.f_19815_);
            }
        }
        if (this.getStatusBroken()) {
            InitParticlesVCM.doBrokenEffect(this, this.f_19796_, this.f_19815_);
        }
        this.applyEngineIssues();
        if (!this.getStatusBroken() && this.PoweredAndHasFuel()) {
            if (this.getStatusEngineIssues() == EngineIssues.MINOR_ISSUE.ordinal()) {
                this.runEngineIssuesMinor();
            }
            if (this.getStatusEngineIssues() == EngineIssues.MAJOR_ISSUE.ordinal()) {
                this.runEngineIssuesMajor();
            }
        }
        this.runTriggerEventSystem();
        ++this.tickingVariableParticle;
        ++this.tickingVariableMinorIssues;
        ++this.tickingVariableMajorIssues;
    }

    @Override
    public InteractionResult m_6096_(Player playerIn, InteractionHand interactionhandIn) {
        if (playerIn.m_36341_()) {
            if (this.getStatusLocked()) {
                if (this.getStatusOwner().equals("")) {
                    this.runHelperMenuAccessFromOutside(playerIn);
                } else if (playerIn.m_20149_().equals(this.getStatusOwner())) {
                    this.runHelperMenuAccessFromOutside(playerIn);
                } else {
                    this.runHelperMenuAccessFromOutside(playerIn);
                }
            } else {
                this.runHelperMenuAccessFromOutside(playerIn);
            }
            this.runHelperAdminTools(playerIn);
            this.runHelperServiceKitDurability(playerIn);
            this.runHelperServiceKitEnergy(playerIn);
            this.runHelperDetailingKit(playerIn);
            this.runHelperToolWrenchPatch(playerIn);
            this.runHelperToolDismounter(playerIn);
            return InteractionResult.SUCCESS;
        }
        if (this.getStatusLocked()) {
            if (this.getStatusOwner().equals("")) {
                if (!this.f_19853_.f_46443_) {
                    return playerIn.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
                }
                return InteractionResult.SUCCESS;
            }
            if (playerIn.m_20149_().equals(this.getStatusOwner())) {
                if (!this.f_19853_.f_46443_) {
                    return playerIn.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
                }
                return InteractionResult.SUCCESS;
            }
            if (!this.inventory.getStackInSlot(1).m_41619_() && this.inventory.getStackInSlot(1).m_41782_() && this.inventory.getStackInSlot(1).m_41783_().m_128461_("tag-machine-owner_vcm").equals(this.getStatusOwner())) {
                if (!this.f_19853_.f_46443_) {
                    return playerIn.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
                }
                return InteractionResult.SUCCESS;
            }
        } else {
            if (!this.f_19853_.f_46443_) {
                return playerIn.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean m_6469_(DamageSource damageSourceIn, float valueIn) {
        if (this.m_6673_(damageSourceIn) || this.getStatusBroken()) {
            return false;
        }
        this.setStatusTriggerEvent(TriggerEvents.HURT_MACHINE.ordinal());
        if (!this.f_19853_.f_46443_ && !this.m_146910_()) {
            this.setHurtDir(-this.getHurtDir());
            this.setHurtTime(10);
            this.setStatusDurabilityActive(this.getStatusDurabilityActive() - (int)valueIn);
            this.m_5834_();
            this.m_146852_(GameEvent.f_157808_, damageSourceIn.m_7639_());
            return true;
        }
        return true;
    }

    public void MainDurabilityLogic() {
        if (this.getStatusDurabilityActive() <= this.GetBaseTickDurability()) {
            this.setStatusDurabilityActive(0);
        }
        if (!this.getStatusBroken()) {
            if (this.PoweredAndHasFuel() && this.getStatusDurabilityActive() > 0) {
                this.ActiveDurabilitySystem();
            }
        } else {
            this.applydurability = 0;
        }
    }

    public void ActiveDurabilitySystem() {
        int turbomodifier = 15;
        if (this.getStatusTurboActivated()) {
            turbomodifier = 11;
        }
        if (this.applydurability >= 20 * turbomodifier) {
            this.applydurability = 0;
            this.setStatusDurabilityActive(this.getStatusDurabilityActive() - this.GetBaseTickDurability());
        }
        ++this.applydurability;
    }

    public int GetBaseTickDurability() {
        return this.baseTickDurability;
    }

    public void MainEnergyLogic() {
        if (!this.getStatusBroken()) {
            if (this.PoweredAndHasFuel() && this.getStatusEnergyActive() < this.getStatusEnergyTotal()) {
                this.ActiveEnergySystem();
            }
        } else {
            this.applyenergy = 0;
            this.setStatusEnergyActive(0);
        }
    }

    public void ActiveEnergySystem() {
        if (this.applyenergy >= 300) {
            this.applyenergy = 0;
            this.setStatusEnergyActive(this.getStatusEnergyActive() + this.GetBaseTickEnergy());
        }
        ++this.applyenergy;
    }

    public int GetBaseTickEnergy() {
        return this.baseTickEnergy;
    }

    @Override
    public void setStatusDurabilityActive(int valueIn) {
        this.f_19804_.m_135381_(DATA_ID_DURABILITY_ACTIVE, (Object)valueIn);
    }

    @Override
    public int getStatusDurabilityActive() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_DURABILITY_ACTIVE);
    }

    @Override
    public void setStatusDurabilityTotal(int valueIn) {
    }

    @Override
    public int getStatusDurabilityTotal() {
        return 250;
    }

    @Override
    public void setStatusEnergyActive(int valueIn) {
        this.f_19804_.m_135381_(DATA_ID_ENERGY_ACTIVE, (Object)valueIn);
    }

    @Override
    public int getStatusEnergyActive() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_ENERGY_ACTIVE);
    }

    @Override
    public void setStatusEnergyTotal(int valueIn) {
    }

    @Override
    public int getStatusEnergyTotal() {
        return 250;
    }

    @Override
    public void setStatusTriggerEvent(int valueIn) {
        this.f_19804_.m_135381_(DATA_ID_TRIGGER_EVENT, (Object)valueIn);
    }

    @Override
    public int getStatusTriggerEvent() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TRIGGER_EVENT);
    }

    @Override
    public void setStatusEngineIssues(int valueIn) {
        this.f_19804_.m_135381_(DATA_ID_ENGINE_ISSUES, (Object)valueIn);
    }

    @Override
    public int getStatusEngineIssues() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_ENGINE_ISSUES);
    }

    protected InteractionResult runHelperToolWrenchPatch(Player playerIn) {
        if (!playerIn.m_21205_().m_41619_() && playerIn.m_21205_().m_41720_() instanceof ItemToolMachineWrench && this.getStatusBroken()) {
            if (playerIn.f_19853_.m_5776_()) {
                playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message." + playerIn.m_21205_().m_41720_() + ".2"), playerIn.m_142081_());
            }
            this.setStatusTriggerEvent(TriggerEvents.PATCH_MACHINE.ordinal());
            this.setStatusDurabilityActive(this.getStatusDurabilityActive() + 5);
            this.setStatusBroken(false);
            playerIn.m_21205_().m_41622_(5, (LivingEntity)playerIn, player -> player.m_21190_(player.m_7655_()));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    protected InteractionResult runHelperToolDismounter(Player playerIn) {
        if (!playerIn.m_21205_().m_41619_() && playerIn.m_21205_().m_41720_() instanceof ItemToolDismounterPlayer && this.m_20160_()) {
            this.m_20153_();
            if (playerIn.f_19853_.m_5776_()) {
                playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message." + playerIn.m_21205_().m_41720_() + ".ejected"), playerIn.m_142081_());
            }
            this.setStatusTriggerEvent(TriggerEvents.DISMOUNT_ENTITY.ordinal());
            playerIn.m_21205_().m_41622_(5, (LivingEntity)playerIn, player -> player.m_21190_(player.m_7655_()));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    protected InteractionResult runHelperAdminTools(Player playerIn) {
        if (!playerIn.m_21205_().m_41619_()) {
            if (playerIn.m_21205_().m_41720_() instanceof ItemAdminMachineRemover) {
                if (playerIn.f_19853_.m_5776_()) {
                    playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.admintool_machine_remover.1"), playerIn.m_142081_());
                }
                this.setStatusTriggerEvent(TriggerEvents.ADMIN_TOOLS.ordinal());
                this.dropInventory();
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return InteractionResult.SUCCESS;
            }
            if (playerIn.m_21205_().m_41720_() instanceof ItemAdminOwnerEraser) {
                if (playerIn.f_19853_.m_5776_()) {
                    playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.admintool_owner_eraser.1"), playerIn.m_142081_());
                }
                this.setStatusTriggerEvent(TriggerEvents.ADMIN_TOOLS.ordinal());
                this.setStatusLocked(false);
                this.setStatusOwner("");
                return InteractionResult.SUCCESS;
            }
            if (playerIn.m_21205_().m_41720_() instanceof ItemAdminMaxMaintenance) {
                if (playerIn.f_19853_.m_5776_()) {
                    playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.admintool_max_maintenance.1"), playerIn.m_142081_());
                }
                this.setStatusTriggerEvent(TriggerEvents.ADMIN_TOOLS.ordinal());
                this.setStatusDurabilityActive(this.getStatusDurabilityTotal());
                this.setStatusEnergyActive(this.getStatusEnergyTotal());
                this.setStatusBroken(false);
                return InteractionResult.SUCCESS;
            }
            if (playerIn.m_21205_().m_41720_() instanceof ItemAdminMachineBreaker) {
                if (playerIn.f_19853_.m_5776_()) {
                    playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.admintool_machine_breaker.1"), playerIn.m_142081_());
                }
                this.setStatusTriggerEvent(TriggerEvents.ADMIN_TOOLS.ordinal());
                this.setStatusDurabilityActive(5);
                this.setStatusEnergyActive(0);
                this.setStatusBroken(true);
                this.setStatusPowered(false);
                this.setStatusVeryBrokenCounter(2);
                return InteractionResult.SUCCESS;
            }
            if (playerIn.m_21205_().m_41720_() instanceof ItemAdminTextureShifter) {
                if (playerIn.f_19853_.m_5776_()) {
                    playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.admintool_texture_shifter.1"), playerIn.m_142081_());
                }
                this.setStatusTriggerEvent(TriggerEvents.ADMIN_TOOLS.ordinal());
                this.setStatusTexturePanel(this.getStatusTexturePanel() + 1);
                if (this.getStatusTexturePanel() > MachineTextures.values().length) {
                    this.setStatusTexturePanel(0);
                }
                this.setStatusTextureMetal(this.getStatusTextureMetal() + 1);
                if (this.getStatusTextureMetal() > MachineTextures.values().length) {
                    this.setStatusTextureMetal(0);
                }
                this.setStatusTextureCloth(this.getStatusTextureCloth() + 1);
                if (this.getStatusTextureCloth() > MachineTextures.values().length) {
                    this.setStatusTextureCloth(0);
                }
                this.setStatusTextureFrame(this.getStatusTextureFrame() + 1);
                if (this.getStatusTextureFrame() > MachineTextures.values().length) {
                    this.setStatusTextureFrame(0);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    protected InteractionResult runHelperServiceKitDurability(Player playerIn) {
        if (!playerIn.m_21205_().m_41619_() && playerIn.m_21205_().m_41720_() instanceof ItemServiceDurabilityKit) {
            if (this.getStatusDurabilityActive() >= this.getStatusDurabilityTotal()) {
                if (this.getStatusVeryBrokenCounter() > 0) {
                    if (playerIn.f_19853_.m_5776_()) {
                        playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.kit_service_durability.succeed"), playerIn.m_142081_());
                    }
                    this.setStatusTriggerEvent(TriggerEvents.ADD_DURABILITY.ordinal());
                    this.setStatusVeryBrokenCounter(0);
                    playerIn.m_21205_().m_41774_(1);
                    if (playerIn.m_21205_().m_41619_()) {
                        playerIn.m_150109_().m_36057_(playerIn.m_21205_());
                    }
                } else if (playerIn.f_19853_.m_5776_()) {
                    playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.kit_service_durability.failed"), playerIn.m_142081_());
                }
            } else if (this.getStatusDurabilityActive() + ((ItemServiceDurabilityKit)playerIn.m_21205_().m_41720_()).getDurabilityRestoreAmount() >= this.getStatusDurabilityTotal()) {
                if (playerIn.f_19853_.m_5776_()) {
                    playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.kit_service_durability.succeed"), playerIn.m_142081_());
                }
                this.setStatusTriggerEvent(TriggerEvents.ADD_DURABILITY.ordinal());
                this.setStatusDurabilityActive(this.getStatusDurabilityTotal());
                this.setStatusVeryBrokenCounter(0);
                playerIn.m_21205_().m_41774_(1);
                if (playerIn.m_21205_().m_41619_()) {
                    playerIn.m_150109_().m_36057_(playerIn.m_21205_());
                }
            } else {
                if (playerIn.f_19853_.m_5776_()) {
                    playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.kit_service_durability.succeed"), playerIn.m_142081_());
                }
                this.setStatusTriggerEvent(TriggerEvents.ADD_DURABILITY.ordinal());
                this.setStatusDurabilityActive(this.getStatusDurabilityActive() + ((ItemServiceDurabilityKit)playerIn.m_21205_().m_41720_()).getDurabilityRestoreAmount());
                this.setStatusVeryBrokenCounter(0);
                playerIn.m_21205_().m_41774_(1);
                if (playerIn.m_21205_().m_41619_()) {
                    playerIn.m_150109_().m_36057_(playerIn.m_21205_());
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected InteractionResult runHelperServiceKitEnergy(Player playerIn) {
        if (!playerIn.m_21205_().m_41619_() && playerIn.m_21205_().m_41720_() instanceof ItemServiceEnergyKit) {
            if (this.getStatusEnergyActive() >= this.getStatusEnergyTotal()) {
                if (playerIn.f_19853_.m_5776_()) {
                    playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.kit_service_energy.failed"), playerIn.m_142081_());
                }
            } else if (this.getStatusEnergyActive() + ((ItemServiceEnergyKit)playerIn.m_21205_().m_41720_()).getEnergyRestoreAmount() >= this.getStatusEnergyTotal()) {
                if (playerIn.f_19853_.m_5776_()) {
                    playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.kit_service_energy.succeed"), playerIn.m_142081_());
                }
                this.setStatusTriggerEvent(TriggerEvents.ADD_ENERGY.ordinal());
                this.setStatusEnergyActive(this.getStatusEnergyTotal());
                playerIn.m_21205_().m_41774_(1);
                if (playerIn.m_21205_().m_41619_()) {
                    playerIn.m_150109_().m_36057_(playerIn.m_21205_());
                }
            } else {
                if (playerIn.f_19853_.m_5776_()) {
                    playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.kit_service_energy.succeed"), playerIn.m_142081_());
                }
                this.setStatusTriggerEvent(TriggerEvents.ADD_ENERGY.ordinal());
                this.setStatusEnergyActive(this.getStatusEnergyActive() + ((ItemServiceEnergyKit)playerIn.m_21205_().m_41720_()).getEnergyRestoreAmount());
                playerIn.m_21205_().m_41774_(1);
                if (playerIn.m_21205_().m_41619_()) {
                    playerIn.m_150109_().m_36057_(playerIn.m_21205_());
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected InteractionResult runHelperDetailingKit(Player playerIn) {
        if (playerIn.m_21205_().m_41619_()) return InteractionResult.PASS;
        if (playerIn.m_21205_().m_41720_() instanceof ItemDetailingKit) {
            ItemStack selectedkit = playerIn.m_21205_();
            if (((ItemDetailingKit)selectedkit.m_41720_()).getKitType() == ItemDetailingKit.Type.PANEL) {
                if (!selectedkit.m_41782_()) {
                    if (!playerIn.f_19853_.m_5776_()) return InteractionResult.SUCCESS;
                    playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.detailingkitpanel.notag"), playerIn.m_142081_());
                    return InteractionResult.SUCCESS;
                }
                if (selectedkit.m_41783_().m_128451_("tag-detailing-kit-selected_vcm") == this.getStatusTexturePanel()) {
                    if (!playerIn.f_19853_.m_5776_()) return InteractionResult.SUCCESS;
                    playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.detailingkitpanel.failed"), playerIn.m_142081_());
                    return InteractionResult.SUCCESS;
                }
                this.setStatusTexturePanel(selectedkit.m_41783_().m_128451_("tag-detailing-kit-selected_vcm"));
                this.setStatusTriggerEvent(TriggerEvents.ADD_DURABILITY.ordinal());
                playerIn.m_21205_().m_41774_(1);
                if (playerIn.m_21205_().m_41619_()) {
                    playerIn.m_150109_().m_36057_(playerIn.m_21205_());
                }
                if (!playerIn.f_19853_.m_5776_()) return InteractionResult.SUCCESS;
                playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.detailingkitpanel.success"), playerIn.m_142081_());
                return InteractionResult.SUCCESS;
            }
            if (((ItemDetailingKit)selectedkit.m_41720_()).getKitType() == ItemDetailingKit.Type.METAL) {
                if (!selectedkit.m_41782_()) {
                    if (!playerIn.f_19853_.m_5776_()) return InteractionResult.SUCCESS;
                    playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.detailingkitpanel.notag"), playerIn.m_142081_());
                    return InteractionResult.SUCCESS;
                }
                if (selectedkit.m_41783_().m_128451_("tag-detailing-kit-selected_vcm") == this.getStatusTextureMetal()) {
                    if (!playerIn.f_19853_.m_5776_()) return InteractionResult.SUCCESS;
                    playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.detailingkitpanel.failed"), playerIn.m_142081_());
                    return InteractionResult.SUCCESS;
                }
                this.setStatusTextureMetal(selectedkit.m_41783_().m_128451_("tag-detailing-kit-selected_vcm"));
                this.setStatusTriggerEvent(TriggerEvents.ADD_DURABILITY.ordinal());
                playerIn.m_21205_().m_41774_(1);
                if (playerIn.m_21205_().m_41619_()) {
                    playerIn.m_150109_().m_36057_(playerIn.m_21205_());
                }
                if (!playerIn.f_19853_.m_5776_()) return InteractionResult.SUCCESS;
                playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.detailingkitpanel.success"), playerIn.m_142081_());
                return InteractionResult.SUCCESS;
            }
            if (((ItemDetailingKit)selectedkit.m_41720_()).getKitType() == ItemDetailingKit.Type.CLOTH) {
                if (!selectedkit.m_41782_()) {
                    if (!playerIn.f_19853_.m_5776_()) return InteractionResult.SUCCESS;
                    playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.detailingkitpanel.notag"), playerIn.m_142081_());
                    return InteractionResult.SUCCESS;
                }
                if (selectedkit.m_41783_().m_128451_("tag-detailing-kit-selected_vcm") == this.getStatusTextureCloth()) {
                    if (!playerIn.f_19853_.m_5776_()) return InteractionResult.SUCCESS;
                    playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.detailingkitpanel.failed"), playerIn.m_142081_());
                    return InteractionResult.SUCCESS;
                }
                this.setStatusTextureCloth(selectedkit.m_41783_().m_128451_("tag-detailing-kit-selected_vcm"));
                this.setStatusTriggerEvent(TriggerEvents.ADD_DURABILITY.ordinal());
                playerIn.m_21205_().m_41774_(1);
                if (playerIn.m_21205_().m_41619_()) {
                    playerIn.m_150109_().m_36057_(playerIn.m_21205_());
                }
                if (!playerIn.f_19853_.m_5776_()) return InteractionResult.SUCCESS;
                playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.detailingkitpanel.success"), playerIn.m_142081_());
                return InteractionResult.SUCCESS;
            }
            if (((ItemDetailingKit)selectedkit.m_41720_()).getKitType() != ItemDetailingKit.Type.FRAME) return InteractionResult.SUCCESS;
            if (!selectedkit.m_41782_()) {
                if (!playerIn.f_19853_.m_5776_()) return InteractionResult.SUCCESS;
                playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.detailingkitpanel.notag"), playerIn.m_142081_());
                return InteractionResult.SUCCESS;
            }
            if (selectedkit.m_41783_().m_128451_("tag-detailing-kit-selected_vcm") == this.getStatusTextureFrame()) {
                if (!playerIn.f_19853_.m_5776_()) return InteractionResult.SUCCESS;
                playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.detailingkitpanel.failed"), playerIn.m_142081_());
                return InteractionResult.SUCCESS;
            }
            this.setStatusTextureFrame(selectedkit.m_41783_().m_128451_("tag-detailing-kit-selected_vcm"));
            this.setStatusTriggerEvent(TriggerEvents.ADD_DURABILITY.ordinal());
            playerIn.m_21205_().m_41774_(1);
            if (playerIn.m_21205_().m_41619_()) {
                playerIn.m_150109_().m_36057_(playerIn.m_21205_());
            }
            if (!playerIn.f_19853_.m_5776_()) return InteractionResult.SUCCESS;
            playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.detailingkitpanel.success"), playerIn.m_142081_());
            return InteractionResult.SUCCESS;
        }
        if (playerIn.m_21205_().m_41720_() instanceof ItemAdminOwnerEraser) {
            if (playerIn.f_19853_.m_5776_()) {
                playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.admintool_owner_eraser.1"), playerIn.m_142081_());
            }
            this.setStatusTriggerEvent(TriggerEvents.ADMIN_TOOLS.ordinal());
            this.setStatusLocked(false);
            this.setStatusOwner("");
            return InteractionResult.SUCCESS;
        }
        if (playerIn.m_21205_().m_41720_() instanceof ItemAdminMaxMaintenance) {
            if (playerIn.f_19853_.m_5776_()) {
                playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.admintool_max_maintenance.1"), playerIn.m_142081_());
            }
            this.setStatusTriggerEvent(TriggerEvents.ADMIN_TOOLS.ordinal());
            this.setStatusDurabilityActive(this.getStatusDurabilityTotal());
            this.setStatusEnergyActive(this.getStatusEnergyTotal());
            this.setStatusBroken(false);
            return InteractionResult.SUCCESS;
        }
        if (playerIn.m_21205_().m_41720_() instanceof ItemAdminMachineBreaker) {
            if (playerIn.f_19853_.m_5776_()) {
                playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.admintool_machine_breaker.1"), playerIn.m_142081_());
            }
            this.setStatusTriggerEvent(TriggerEvents.ADMIN_TOOLS.ordinal());
            this.setStatusDurabilityActive(5);
            this.setStatusEnergyActive(0);
            this.setStatusBroken(true);
            this.setStatusPowered(false);
            this.setStatusVeryBrokenCounter(2);
            return InteractionResult.SUCCESS;
        }
        if (!(playerIn.m_21205_().m_41720_() instanceof ItemAdminTextureShifter)) return InteractionResult.PASS;
        if (playerIn.f_19853_.m_5776_()) {
            playerIn.m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.admintool_texture_shifter.1"), playerIn.m_142081_());
        }
        this.setStatusTriggerEvent(TriggerEvents.ADMIN_TOOLS.ordinal());
        this.setStatusTexturePanel(this.getStatusTexturePanel() + 1);
        if (this.getStatusTexturePanel() > MachineTextures.values().length) {
            this.setStatusTexturePanel(0);
        }
        this.setStatusTextureMetal(this.getStatusTextureMetal() + 1);
        if (this.getStatusTextureMetal() > MachineTextures.values().length) {
            this.setStatusTextureMetal(0);
        }
        this.setStatusTextureCloth(this.getStatusTextureCloth() + 1);
        if (this.getStatusTextureCloth() > MachineTextures.values().length) {
            this.setStatusTextureCloth(0);
        }
        this.setStatusTextureFrame(this.getStatusTextureFrame() + 1);
        if (this.getStatusTextureFrame() <= MachineTextures.values().length) return InteractionResult.SUCCESS;
        this.setStatusTextureFrame(0);
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult runHelperMenuAccessFromOutside(Player playerIn) {
        if (!playerIn.m_21205_().m_41619_() && (playerIn.m_21205_().m_41720_() instanceof ItemToolMachineWrench || playerIn.m_21205_().m_41720_() instanceof ItemToolDismounter || playerIn.m_21205_().m_41720_() instanceof ItemToolDismounterPlayer || playerIn.m_21205_().m_41720_() instanceof ItemToolNameChanger || playerIn.m_21205_().m_41720_() instanceof ItemToolRadioExpansion || playerIn.m_21205_().m_41720_() instanceof ItemServiceDurabilityKit || playerIn.m_21205_().m_41720_() instanceof ItemServiceEnergyKit || playerIn.m_21205_().m_41720_() instanceof ItemDetailingKit || playerIn.m_21205_().m_41720_() instanceof ItemAdminMachineRemover || playerIn.m_21205_().m_41720_() instanceof ItemAdminOwnerEraser || playerIn.m_21205_().m_41720_() instanceof ItemAdminMaxMaintenance || playerIn.m_21205_().m_41720_() instanceof ItemAdminMachineBreaker || playerIn.m_21205_().m_41720_() instanceof ItemAdminTextureShifter)) {
            return InteractionResult.SUCCESS;
        }
        this.openMachineMenu(playerIn);
        return InteractionResult.SUCCESS;
    }

    protected void explodeMachine() {
        if (!this.f_19853_.f_46443_) {
            Explosion.BlockInteraction explosion$blockinteraction = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
            float f = 1.0f;
            this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3.0f * f, explosion$blockinteraction);
        }
        this.setStatusTriggerEvent(TriggerEvents.EXPLODE_MACHINE.ordinal());
    }

    private void runTriggerEventSystem() {
        if (this.getStatusTriggerEvent() == TriggerEvents.FIRST_SPAWNED.ordinal()) {
            InitParticlesVCM.doEffectFirstSpawn(this, this.f_19796_, this.f_19815_);
            this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11671_, SoundSource.NEUTRAL, 0.5f, 1.0f);
            this.setStatusTriggerEvent(TriggerEvents.NO_EVENT.ordinal());
        }
        if (this.getStatusTriggerEvent() == TriggerEvents.HURT_MACHINE.ordinal()) {
            InitParticlesVCM.doEffectHurtMachine(this, this.f_19796_, this.f_19815_);
            this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11683_, SoundSource.NEUTRAL, 0.5f, 0.4f / (this.f_19853_.m_5822_().nextFloat() * 0.4f + 0.8f));
            this.setStatusTriggerEvent(TriggerEvents.NO_EVENT.ordinal());
        }
        if (this.getStatusTriggerEvent() == TriggerEvents.BREAK_MACHINE.ordinal()) {
            InitParticlesVCM.doEffectBreakMachine(this, this.f_19796_, this.f_19815_);
            this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.NEUTRAL, 0.5f, 0.4f / (this.f_19853_.m_5822_().nextFloat() * 0.4f + 0.8f));
            this.setStatusTriggerEvent(TriggerEvents.NO_EVENT.ordinal());
        }
        if (this.getStatusTriggerEvent() == TriggerEvents.EXPLODE_MACHINE.ordinal()) {
            InitParticlesVCM.doEffectExplodeMachine(this, this.f_19796_, this.f_19815_);
            this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.NEUTRAL, 0.5f, 0.4f / (this.f_19853_.m_5822_().nextFloat() * 0.4f + 0.8f));
            this.setStatusTriggerEvent(TriggerEvents.NO_EVENT.ordinal());
        }
        if (this.getStatusTriggerEvent() == TriggerEvents.PATCH_MACHINE.ordinal()) {
            InitParticlesVCM.doEffectPatchMachine(this, this.f_19796_, this.f_19815_);
            this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11794_, SoundSource.NEUTRAL, 0.5f, 1.0f);
            this.setStatusTriggerEvent(TriggerEvents.NO_EVENT.ordinal());
        }
        if (this.getStatusTriggerEvent() == TriggerEvents.REPAIR_MACHINE.ordinal()) {
            InitParticlesVCM.doEffectRepairMachine(this, this.f_19796_, this.f_19815_);
            this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11671_, SoundSource.NEUTRAL, 0.5f, 0.4f / (this.f_19853_.m_5822_().nextFloat() * 0.4f + 0.8f));
            this.setStatusTriggerEvent(TriggerEvents.NO_EVENT.ordinal());
        }
        if (this.getStatusTriggerEvent() == TriggerEvents.ADD_DURABILITY.ordinal()) {
            InitParticlesVCM.doEffectAddDurability(this, this.f_19796_, this.f_19815_);
            this.f_19853_.m_6269_((Player)null, (Entity)this, (SoundEvent)InitSoundsVCM.SOUND_HEAL.get(), SoundSource.NEUTRAL, 0.5f, 1.0f);
            this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11671_, SoundSource.NEUTRAL, 0.5f, 1.0f);
            this.setStatusTriggerEvent(TriggerEvents.NO_EVENT.ordinal());
        }
        if (this.getStatusTriggerEvent() == TriggerEvents.ADD_ENERGY.ordinal()) {
            InitParticlesVCM.doEffectAddEnergy(this, this.f_19796_, this.f_19815_);
            this.f_19853_.m_6269_((Player)null, (Entity)this, (SoundEvent)InitSoundsVCM.SOUND_HEAL.get(), SoundSource.NEUTRAL, 0.5f, 1.0f);
            this.setStatusTriggerEvent(TriggerEvents.NO_EVENT.ordinal());
        }
        if (this.getStatusTriggerEvent() == TriggerEvents.MINOR_ISSUE.ordinal()) {
            InitParticlesVCM.doEffectMinorIssue(this, this.f_19796_, this.f_19815_);
            this.f_19853_.m_6269_((Player)null, (Entity)this, SoundEvents.f_11744_, SoundSource.NEUTRAL, 0.5f, 1.0f);
            this.setStatusTriggerEvent(TriggerEvents.NO_EVENT.ordinal());
        }
        if (this.getStatusTriggerEvent() == TriggerEvents.MAJOR_ISSUE.ordinal()) {
            InitParticlesVCM.doEffectMajorIssue(this, this.f_19796_, this.f_19815_);
            this.f_19853_.m_6269_((Player)null, (Entity)this, SoundEvents.f_11745_, SoundSource.NEUTRAL, 0.5f, 1.0f);
            this.setStatusTriggerEvent(TriggerEvents.NO_EVENT.ordinal());
        }
        if (this.getStatusTriggerEvent() == TriggerEvents.RECORD_PLAY.ordinal()) {
            if (!this.inventory.getStackInSlot(2).m_41619_() && this.inventory.getStackInSlot(2).m_41720_() instanceof RecordItem) {
                RecordItem recordinslot = (RecordItem)this.inventory.getStackInSlot(2).m_41720_();
                this.f_19853_.m_6269_((Player)null, (Entity)this, recordinslot.m_43051_(), SoundSource.RECORDS, 0.5f, 1.0f);
            }
            this.setStatusTriggerEvent(TriggerEvents.NO_EVENT.ordinal());
        }
        if (this.getStatusTriggerEvent() == TriggerEvents.RECORD_STOP.ordinal()) {
            if (this.f_19853_.m_5776_()) {
                Minecraft.m_91087_().m_91106_().m_120386_((ResourceLocation)null, SoundSource.RECORDS);
            }
            this.setStatusTriggerEvent(TriggerEvents.NO_EVENT.ordinal());
        }
        if (this.getStatusTriggerEvent() == TriggerEvents.DISMOUNT_ENTITY.ordinal()) {
            InitParticlesVCM.doEffectDismountEntity(this, this.f_19796_, this.f_19815_);
            this.f_19853_.m_6269_((Player)null, (Entity)this, SoundEvents.f_144243_, SoundSource.NEUTRAL, 0.5f, 1.0f);
            this.setStatusTriggerEvent(TriggerEvents.NO_EVENT.ordinal());
        }
        if (this.getStatusTriggerEvent() == TriggerEvents.ADMIN_TOOLS.ordinal()) {
            InitParticlesVCM.doEffectAdminTools(this, this.f_19796_, this.f_19815_);
            this.f_19853_.m_6269_((Player)null, (Entity)this, (SoundEvent)InitSoundsVCM.SOUND_UPGRADE.get(), SoundSource.NEUTRAL, 0.5f, 1.0f);
            this.setStatusTriggerEvent(TriggerEvents.NO_EVENT.ordinal());
        }
    }

    protected void applyEngineIssues() {
        if (!this.getStatusBroken()) {
            if (this.getStatusDurabilityActive() <= this.startMajorEngineIssues) {
                if (this.getStatusEngineIssues() != EngineIssues.MAJOR_ISSUE.ordinal()) {
                    this.setStatusEngineIssues(EngineIssues.MAJOR_ISSUE.ordinal());
                }
            } else if (this.getStatusDurabilityActive() <= this.startMinorEngineIssues) {
                if (this.getStatusEngineIssues() != EngineIssues.MINOR_ISSUE.ordinal()) {
                    this.setStatusEngineIssues(EngineIssues.MINOR_ISSUE.ordinal());
                }
            } else if (this.getStatusEngineIssues() != EngineIssues.NO_ISSUES.ordinal()) {
                this.setStatusEngineIssues(EngineIssues.NO_ISSUES.ordinal());
            }
        } else if (this.getStatusEngineIssues() != EngineIssues.NO_ISSUES.ordinal()) {
            this.setStatusEngineIssues(EngineIssues.NO_ISSUES.ordinal());
        }
    }

    protected void runEngineIssuesMinor() {
        if (this.tickingVariableMinorIssues >= 600) {
            if (this.tickingVariableMinorIssues >= 3600) {
                this.setStatusTriggerEvent(TriggerEvents.MINOR_ISSUE.ordinal());
                this.tickingVariableMinorIssues = 0;
            } else if (this.f_19853_.f_46441_.nextInt(1, 201) <= 1) {
                this.setStatusTriggerEvent(TriggerEvents.MINOR_ISSUE.ordinal());
                this.tickingVariableMinorIssues = 0;
            }
        }
    }

    protected void runEngineIssuesMajor() {
        if (this.tickingVariableMajorIssues >= 300) {
            if (this.tickingVariableMajorIssues >= 1800) {
                this.setStatusTriggerEvent(TriggerEvents.MAJOR_ISSUE.ordinal());
                this.tickingVariableMajorIssues = 0;
            } else if (this.f_19853_.f_46441_.nextInt(1, 201) <= 2) {
                this.setStatusTriggerEvent(TriggerEvents.MAJOR_ISSUE.ordinal());
                this.tickingVariableMajorIssues = 0;
            }
        }
    }
}

