/*
 * Decompiled with CFR 0.152.
 */
package com.vies.viescraftmachines.common.entities.machines;

import com.vies.viescraftmachines.common.entities.machines.EntityMountable;
import com.vies.viescraftmachines.common.screens.MachineTypeFlyingMenu;
import com.vies.viescraftmachines.network.MessagesVCM;
import com.vies.viescraftmachines.network.packets.PacketOpenRidingMenu;
import com.vies.viescraftmachines.network.packets.PacketToggleMachineTurboOff;
import com.vies.viescraftmachines.network.packets.PacketToggleMachineTurboOn;
import com.vies.viescraftmachines.util.enums.MachineType;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public class EntityMachineBase
extends EntityMountable
implements Container,
MenuProvider {
    private static final EntityDataAccessor<String> DATA_ID_OWNER = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> DATA_ID_OWNERDISPLAYNAME = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> DATA_ID_LOCKED = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_ID_TEXTUREPANEL = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_TEXTUREMETAL = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_TEXTURECLOTH = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_TEXTUREFRAME = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_ID_ITEMINSLOT1 = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ID_ITEMINSLOT6 = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ID_ITEMINSLOT7 = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ID_ITEMINSLOT8 = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ID_ITEMINSLOT9 = SynchedEntityData.m_135353_(EntityMachineBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected EntityDimensions f_19815_;
    protected int currentTotalFuel;
    protected int overallTotalFuel;
    protected int stacksizeOfFuelSlot;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int switchIn) {
            switch (switchIn) {
                case 0: {
                    return EntityMachineBase.this.getStatusCurrentActiveFuel();
                }
                case 1: {
                    return EntityMachineBase.this.currentTotalFuel;
                }
                case 2: {
                    return EntityMachineBase.this.getStatusOverallActiveFuel();
                }
                case 3: {
                    return EntityMachineBase.this.overallTotalFuel;
                }
                case 4: {
                    return EntityMachineBase.this.stacksizeOfFuelSlot;
                }
            }
            return 0;
        }

        public void m_8050_(int switchIn, int varIn) {
            switch (switchIn) {
                case 0: {
                    EntityMachineBase.this.setStatusCurrentActiveFuel(varIn);
                    break;
                }
                case 1: {
                    EntityMachineBase.this.currentTotalFuel = varIn;
                    break;
                }
                case 2: {
                    EntityMachineBase.this.setStatusOverallActiveFuel(varIn);
                    break;
                }
                case 3: {
                    EntityMachineBase.this.overallTotalFuel = varIn;
                    break;
                }
                case 4: {
                    EntityMachineBase.this.stacksizeOfFuelSlot = varIn;
                }
            }
        }

        public int m_6499_() {
            return 5;
        }
    };
    public int MaxSlotSize = 128;
    private NonNullList<ItemStack> itemStacks = NonNullList.m_122780_((int)this.MaxSlotSize, (Object)ItemStack.f_41583_);
    public ItemStackHandler inventory = this.createHandler();
    public LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.of(() -> this.inventory);

    public EntityMachineBase(EntityType<? extends EntityMachineBase> entitytypeIn, Level levelIn) {
        super(entitytypeIn, levelIn);
        this.f_19815_ = entitytypeIn.m_20680_();
        this.lazyItemHandler = LazyOptional.of(() -> this.inventory);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_OWNER, (Object)"");
        this.f_19804_.m_135372_(DATA_ID_OWNERDISPLAYNAME, (Object)"");
        this.f_19804_.m_135372_(DATA_ID_LOCKED, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_TEXTUREPANEL, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_TEXTUREMETAL, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_TEXTURECLOTH, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_TEXTUREFRAME, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_ITEMINSLOT1, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_ITEMINSLOT6, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_ITEMINSLOT7, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_ITEMINSLOT8, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_ITEMINSLOT9, (Object)false);
    }

    @Override
    protected void m_7380_(CompoundTag tagIn) {
        this.IsStorageChestInSlot1();
        this.IsStorageChestInSlot6();
        this.IsStorageChestInSlot7();
        this.IsStorageChestInSlot8();
        this.IsStorageChestInSlot9();
        tagIn.m_128365_("tag-machine-inventory_vcm", (Tag)this.inventory.serializeNBT());
        tagIn.m_128359_("tag-machine-owner_vcm", this.getStatusOwner());
        tagIn.m_128359_("tag-machine-ownerdisplayname_vcm", this.getStatusOwnerDisplayName());
        tagIn.m_128379_("tag-machine-locked_vcm", this.getStatusLocked());
        tagIn.m_128405_("tag-machine-texturepanel_vcm", this.getStatusTexturePanel());
        tagIn.m_128405_("tag-machine-texturemetal_vcm", this.getStatusTextureMetal());
        tagIn.m_128405_("tag-machine-texturecloth_vcm", this.getStatusTextureCloth());
        tagIn.m_128405_("tag-machine-textureframe_vcm", this.getStatusTextureFrame());
        tagIn.m_128379_("tag-machine-iteminslot1_vcm", this.getStatusItemInSlot1());
        tagIn.m_128379_("tag-machine-iteminslot6_vcm", this.getStatusItemInSlot6());
        tagIn.m_128379_("tag-machine-iteminslot7_vcm", this.getStatusItemInSlot7());
        tagIn.m_128379_("tag-machine-iteminslot8_vcm", this.getStatusItemInSlot8());
        tagIn.m_128379_("tag-machine-iteminslot9_vcm", this.getStatusItemInSlot9());
        super.m_7380_(tagIn);
    }

    @Override
    protected void m_7378_(CompoundTag tagIn) {
        super.m_7378_(tagIn);
        this.inventory.deserializeNBT(tagIn.m_128469_("tag-machine-inventory_vcm"));
        this.setStatusOwner(tagIn.m_128461_("tag-machine-owner_vcm"));
        this.setStatusOwnerDisplayName(tagIn.m_128461_("tag-machine-ownerdisplayname_vcm"));
        this.setStatusLocked(tagIn.m_128471_("tag-machine-locked_vcm"));
        this.setStatusTexturePanel(tagIn.m_128451_("tag-machine-texturepanel_vcm"));
        this.setStatusTextureMetal(tagIn.m_128451_("tag-machine-texturemetal_vcm"));
        this.setStatusTextureCloth(tagIn.m_128451_("tag-machine-texturecloth_vcm"));
        this.setStatusTextureFrame(tagIn.m_128451_("tag-machine-textureframe_vcm"));
        this.setStatusItemInSlot1(tagIn.m_128471_("tag-machine-iteminslot1_vcm"));
        this.setStatusItemInSlot6(tagIn.m_128471_("tag-machine-iteminslot6_vcm"));
        this.setStatusItemInSlot7(tagIn.m_128471_("tag-machine-iteminslot7_vcm"));
        this.setStatusItemInSlot8(tagIn.m_128471_("tag-machine-iteminslot8_vcm"));
        this.setStatusItemInSlot9(tagIn.m_128471_("tag-machine-iteminslot9_vcm"));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_6688_() instanceof Player && (this.getStatusOwner() == "" || this.getStatusOwnerDisplayName() == "")) {
            this.setStatusOwner(this.m_6688_().m_142081_().toString());
            this.setStatusOwnerDisplayName(this.f_19853_.m_46003_(UUID.fromString(this.getStatusOwner())).m_5446_().getString());
            if (this.m_6688_().f_19853_.m_5776_()) {
                this.m_6688_().m_6352_((Component)new TranslatableComponent("item.viescraftmachines.message.youarenowtheowner.1"), this.m_6688_().m_142081_());
            }
        }
        if (this.m_6109_() && this.f_19853_.f_46443_ && this.m_6688_() instanceof Player && this.inputMachineMenu) {
            MessagesVCM.sendToServer(new PacketOpenRidingMenu(this.m_142049_()));
        }
        if (this.f_19853_.m_5776_()) {
            if (this.inputActivateTurbo) {
                if (!this.getStatusTurboActivated()) {
                    MessagesVCM.sendToServer(new PacketToggleMachineTurboOn(this.m_142049_()));
                }
            } else if (this.getStatusTurboActivated()) {
                MessagesVCM.sendToServer(new PacketToggleMachineTurboOff(this.m_142049_()));
            }
        }
        if (this.getStatusLocked() && this.m_6688_() instanceof Player && !this.getStatusOwner().equals(this.m_6688_().m_20149_())) {
            if (this.inventory.getStackInSlot(1).m_41619_()) {
                this.m_6688_().m_8127_();
            } else if (!this.inventory.getStackInSlot(1).m_41619_() && !this.inventory.getStackInSlot(1).m_41782_()) {
                this.m_6688_().m_8127_();
            } else if (!this.inventory.getStackInSlot(1).m_41619_() && !this.inventory.getStackInSlot(1).m_41783_().m_128461_("tag-machine-owner_vcm").equals(this.getStatusOwner())) {
                this.m_6688_().m_8127_();
            }
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(this.MaxSlotSize){

            protected void onContentsChanged(int slot) {
                EntityMachineBase.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public void dropInventory() {
        SimpleContainer inventoryIn = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            inventoryIn.m_6836_(i, this.inventory.getStackInSlot(i));
        }
        Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)inventoryIn);
    }

    @Override
    public InteractionResult m_6096_(Player playerIn, InteractionHand interactionhandIn) {
        return super.m_6096_(playerIn, interactionhandIn);
    }

    @Nullable
    protected SoundEvent getSoundEngineOn() {
        switch (this.getStatus()) {
            default: 
        }
        return null;
    }

    protected void playAmbientMachineSound() {
        SoundEvent soundevent = this.getSoundEngineOn();
        if (soundevent != null) {
            Vec3 vec3 = this.m_20252_(1.0f);
            this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundevent, this.m_5720_(), this.volumeAmbientMachineSound(), 0.8f + 0.4f * this.f_19796_.nextFloat());
        }
    }

    protected float volumeAmbientMachineSound() {
        return 1.0f;
    }

    public int m_6643_() {
        return this.MaxSlotSize;
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.itemStacks) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int pIndex) {
        return (ItemStack)this.itemStacks.get(pIndex);
    }

    public ItemStack m_7407_(int pIndex, int pCount) {
        return ContainerHelper.m_18969_(this.itemStacks, (int)pIndex, (int)pCount);
    }

    public ItemStack m_8016_(int pIndex) {
        ItemStack itemstack = (ItemStack)this.itemStacks.get(pIndex);
        if (itemstack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.itemStacks.set(pIndex, (Object)ItemStack.f_41583_);
        return itemstack;
    }

    public void m_6836_(int pIndex, ItemStack pStack) {
        this.itemStacks.set(pIndex, (Object)pStack);
        if (!pStack.m_41619_() && pStack.m_41613_() > this.m_6893_()) {
            pStack.m_41764_(this.m_6893_());
        }
    }

    public SlotAccess m_141942_(final int pSlot) {
        return pSlot >= 0 && pSlot < this.m_6643_() ? new SlotAccess(){

            public ItemStack m_142196_() {
                return EntityMachineBase.this.m_8020_(pSlot);
            }

            public boolean m_142104_(ItemStack p_150265_) {
                EntityMachineBase.this.m_6836_(pSlot, p_150265_);
                return true;
            }
        } : super.m_141942_(pSlot);
    }

    public void m_6596_() {
        this.IsStorageChestInSlot1();
        this.IsStorageChestInSlot6();
        this.IsStorageChestInSlot7();
        this.IsStorageChestInSlot8();
        this.IsStorageChestInSlot9();
    }

    public boolean m_6542_(Player pPlayer) {
        if (this.m_146910_()) {
            return false;
        }
        return !(pPlayer.m_20280_((Entity)this) > 64.0);
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        if (!this.f_19853_.f_46443_ && pReason.m_146965_()) {
            Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)this);
        }
        super.m_142687_(pReason);
    }

    public void m_6211_() {
        this.itemStacks.clear();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new MachineTypeFlyingMenu(pContainerId, pPlayerInventory, this, this.dataAccess);
    }

    public Component m_5446_() {
        return new TextComponent(this.getStatusOwnerDisplayName());
    }

    public void setStatusOwner(String valueIn) {
        this.f_19804_.m_135381_(DATA_ID_OWNER, (Object)valueIn);
    }

    public String getStatusOwner() {
        return (String)this.f_19804_.m_135370_(DATA_ID_OWNER);
    }

    public void setStatusOwnerDisplayName(String valueIn) {
        this.f_19804_.m_135381_(DATA_ID_OWNERDISPLAYNAME, (Object)valueIn);
    }

    public String getStatusOwnerDisplayName() {
        return (String)this.f_19804_.m_135370_(DATA_ID_OWNERDISPLAYNAME);
    }

    public void setStatusLocked(boolean valueIn) {
        this.f_19804_.m_135381_(DATA_ID_LOCKED, (Object)valueIn);
    }

    public boolean getStatusLocked() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_LOCKED);
    }

    public void setStatusItemInSlot1(boolean valueIn) {
        this.f_19804_.m_135381_(DATA_ID_ITEMINSLOT1, (Object)valueIn);
    }

    public boolean getStatusItemInSlot1() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_ITEMINSLOT1);
    }

    public void setStatusItemInSlot6(boolean valueIn) {
        this.f_19804_.m_135381_(DATA_ID_ITEMINSLOT6, (Object)valueIn);
    }

    public boolean getStatusItemInSlot6() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_ITEMINSLOT6);
    }

    public void setStatusItemInSlot7(boolean valueIn) {
        this.f_19804_.m_135381_(DATA_ID_ITEMINSLOT7, (Object)valueIn);
    }

    public boolean getStatusItemInSlot7() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_ITEMINSLOT7);
    }

    public void setStatusItemInSlot8(boolean valueIn) {
        this.f_19804_.m_135381_(DATA_ID_ITEMINSLOT8, (Object)valueIn);
    }

    public boolean getStatusItemInSlot8() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_ITEMINSLOT8);
    }

    public void setStatusItemInSlot9(boolean valueIn) {
        this.f_19804_.m_135381_(DATA_ID_ITEMINSLOT9, (Object)valueIn);
    }

    public boolean getStatusItemInSlot9() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_ITEMINSLOT9);
    }

    @Override
    public void setStatusBroken(boolean valueIn) {
    }

    @Override
    public boolean getStatusBroken() {
        return false;
    }

    @Override
    public void setStatusPowered(boolean valueIn) {
    }

    @Override
    public boolean getStatusPowered() {
        return false;
    }

    public void setStatusTurboActivated(boolean valueIn) {
    }

    public boolean getStatusTurboActivated() {
        return false;
    }

    public void setStatusCurrentActiveFuel(int valueIn) {
    }

    public int getStatusCurrentActiveFuel() {
        return 0;
    }

    public void setStatusOverallActiveFuel(int valueIn) {
    }

    public int getStatusOverallActiveFuel() {
        return 0;
    }

    public void setStatusDurabilityActive(int valueIn) {
    }

    public int getStatusDurabilityActive() {
        return 0;
    }

    public void setStatusDurabilityTotal(int valueIn) {
    }

    public int getStatusDurabilityTotal() {
        return 250;
    }

    public void setStatusEnergyActive(int valueIn) {
    }

    public int getStatusEnergyActive() {
        return 250;
    }

    public void setStatusEnergyTotal(int valueIn) {
    }

    public int getStatusEnergyTotal() {
        return 0;
    }

    public void setStatusTriggerEvent(int valueIn) {
    }

    public int getStatusTriggerEvent() {
        return 0;
    }

    public void setStatusEngineIssues(int valueIn) {
    }

    public int getStatusEngineIssues() {
        return 0;
    }

    public void setStatusTexturePanel(int valueIn) {
        this.f_19804_.m_135381_(DATA_ID_TEXTUREPANEL, (Object)valueIn);
    }

    public int getStatusTexturePanel() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TEXTUREPANEL);
    }

    public void setStatusTextureMetal(int valueIn) {
        this.f_19804_.m_135381_(DATA_ID_TEXTUREMETAL, (Object)valueIn);
    }

    public int getStatusTextureMetal() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TEXTUREMETAL);
    }

    public void setStatusTextureCloth(int valueIn) {
        this.f_19804_.m_135381_(DATA_ID_TEXTURECLOTH, (Object)valueIn);
    }

    public int getStatusTextureCloth() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TEXTURECLOTH);
    }

    public void setStatusTextureFrame(int valueIn) {
        this.f_19804_.m_135381_(DATA_ID_TEXTUREFRAME, (Object)valueIn);
    }

    public int getStatusTextureFrame() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TEXTUREFRAME);
    }

    public void openMachineMenu(Player playerIn) {
        if (!this.f_19853_.m_5776_()) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)playerIn;
            NetworkHooks.openGui((ServerPlayer)serverPlayerEntity, (MenuProvider)this, buf -> buf.writeInt(this.m_142049_()));
        }
    }

    protected int GetTierFrame() {
        return 0;
    }

    protected int GetTierEngine() {
        return 0;
    }

    protected int GetTierModule() {
        return 0;
    }

    public int GetModelBase() {
        return 0;
    }

    public int GetModelFrame() {
        return 0;
    }

    public int GetModelEngine() {
        return 0;
    }

    public int GetModelModule() {
        return 0;
    }

    public int GetTextureBase() {
        return 0;
    }

    public int GetTextureFrame() {
        return 0;
    }

    public int GetTextureEngine() {
        return 0;
    }

    public int GetTextureModule() {
        return 0;
    }

    public static void ConvertMachineToItem(Player playerIn) {
    }

    public void shoot(double pX, double pY, double pZ, float pVelocity, float pInaccuracy) {
        Vec3 vec3 = new Vec3(pX, pY, pZ).m_82541_().m_82520_(this.f_19796_.nextGaussian() * (double)0.0075f * (double)pInaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)pInaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)pInaccuracy).m_82490_((double)pVelocity);
        this.m_20256_(vec3);
        double d0 = vec3.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public void shootFromRotation(Entity pShooter, float pX, float pY, float pZ, float pVelocity, float pInaccuracy) {
        float f = -Mth.m_14031_((float)(pY * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pX * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)((pX + pZ) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(pY * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pX * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, pVelocity, pInaccuracy);
        Vec3 vec3 = pShooter.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(vec3.f_82479_, pShooter.m_20096_() ? 0.0 : vec3.f_82480_, vec3.f_82481_));
    }

    public void dropInventoryContentsStorageSlot6() {
        if (this.inventory.getStackInSlot(6).m_41619_() && this.areItemsInStorageSlot6Range(this.inventory)) {
            SimpleContainer inventoryIn = new SimpleContainer(this.inventory.getSlots());
            for (int i = 10; i <= 36; ++i) {
                inventoryIn.m_6836_(i, this.inventory.getStackInSlot(i));
            }
            Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)inventoryIn);
        }
    }

    private boolean areItemsInStorageSlot6Range(ItemStackHandler inventoryIn) {
        boolean hasItems = false;
        if (!(inventoryIn.getStackInSlot(10).m_41619_() && inventoryIn.getStackInSlot(11).m_41619_() && inventoryIn.getStackInSlot(12).m_41619_() && inventoryIn.getStackInSlot(13).m_41619_() && inventoryIn.getStackInSlot(14).m_41619_() && inventoryIn.getStackInSlot(15).m_41619_() && inventoryIn.getStackInSlot(16).m_41619_() && inventoryIn.getStackInSlot(17).m_41619_() && inventoryIn.getStackInSlot(18).m_41619_() && inventoryIn.getStackInSlot(19).m_41619_() && inventoryIn.getStackInSlot(20).m_41619_() && inventoryIn.getStackInSlot(21).m_41619_() && inventoryIn.getStackInSlot(22).m_41619_() && inventoryIn.getStackInSlot(23).m_41619_() && inventoryIn.getStackInSlot(24).m_41619_() && inventoryIn.getStackInSlot(25).m_41619_() && inventoryIn.getStackInSlot(26).m_41619_() && inventoryIn.getStackInSlot(27).m_41619_() && inventoryIn.getStackInSlot(28).m_41619_() && inventoryIn.getStackInSlot(29).m_41619_() && inventoryIn.getStackInSlot(30).m_41619_() && inventoryIn.getStackInSlot(31).m_41619_() && inventoryIn.getStackInSlot(32).m_41619_() && inventoryIn.getStackInSlot(33).m_41619_() && inventoryIn.getStackInSlot(34).m_41619_() && inventoryIn.getStackInSlot(35).m_41619_() && inventoryIn.getStackInSlot(36).m_41619_())) {
            hasItems = true;
        }
        return hasItems;
    }

    public void dropInventoryContentsStorageSlot7() {
        if (this.inventory.getStackInSlot(7).m_41619_() && this.areItemsInStorageSlot7Range(this.inventory)) {
            SimpleContainer inventoryIn = new SimpleContainer(this.inventory.getSlots());
            for (int i = 37; i <= 63; ++i) {
                inventoryIn.m_6836_(i, this.inventory.getStackInSlot(i));
            }
            Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)inventoryIn);
        }
    }

    private boolean areItemsInStorageSlot7Range(ItemStackHandler inventoryIn) {
        boolean hasItems = false;
        if (!(inventoryIn.getStackInSlot(37).m_41619_() && inventoryIn.getStackInSlot(38).m_41619_() && inventoryIn.getStackInSlot(39).m_41619_() && inventoryIn.getStackInSlot(40).m_41619_() && inventoryIn.getStackInSlot(41).m_41619_() && inventoryIn.getStackInSlot(42).m_41619_() && inventoryIn.getStackInSlot(43).m_41619_() && inventoryIn.getStackInSlot(44).m_41619_() && inventoryIn.getStackInSlot(45).m_41619_() && inventoryIn.getStackInSlot(46).m_41619_() && inventoryIn.getStackInSlot(47).m_41619_() && inventoryIn.getStackInSlot(48).m_41619_() && inventoryIn.getStackInSlot(49).m_41619_() && inventoryIn.getStackInSlot(50).m_41619_() && inventoryIn.getStackInSlot(51).m_41619_() && inventoryIn.getStackInSlot(52).m_41619_() && inventoryIn.getStackInSlot(53).m_41619_() && inventoryIn.getStackInSlot(54).m_41619_() && inventoryIn.getStackInSlot(55).m_41619_() && inventoryIn.getStackInSlot(56).m_41619_() && inventoryIn.getStackInSlot(57).m_41619_() && inventoryIn.getStackInSlot(58).m_41619_() && inventoryIn.getStackInSlot(59).m_41619_() && inventoryIn.getStackInSlot(60).m_41619_() && inventoryIn.getStackInSlot(61).m_41619_() && inventoryIn.getStackInSlot(62).m_41619_() && inventoryIn.getStackInSlot(63).m_41619_())) {
            hasItems = true;
        }
        return hasItems;
    }

    public void dropInventoryContentsStorageSlot8() {
        if (this.inventory.getStackInSlot(8).m_41619_() && this.areItemsInStorageSlot8Range(this.inventory)) {
            SimpleContainer inventoryIn = new SimpleContainer(this.inventory.getSlots());
            for (int i = 64; i <= 90; ++i) {
                inventoryIn.m_6836_(i, this.inventory.getStackInSlot(i));
            }
            Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)inventoryIn);
        }
    }

    private boolean areItemsInStorageSlot8Range(ItemStackHandler inventoryIn) {
        boolean hasItems = false;
        if (!(inventoryIn.getStackInSlot(64).m_41619_() && inventoryIn.getStackInSlot(65).m_41619_() && inventoryIn.getStackInSlot(66).m_41619_() && inventoryIn.getStackInSlot(67).m_41619_() && inventoryIn.getStackInSlot(68).m_41619_() && inventoryIn.getStackInSlot(69).m_41619_() && inventoryIn.getStackInSlot(70).m_41619_() && inventoryIn.getStackInSlot(71).m_41619_() && inventoryIn.getStackInSlot(72).m_41619_() && inventoryIn.getStackInSlot(73).m_41619_() && inventoryIn.getStackInSlot(74).m_41619_() && inventoryIn.getStackInSlot(75).m_41619_() && inventoryIn.getStackInSlot(76).m_41619_() && inventoryIn.getStackInSlot(77).m_41619_() && inventoryIn.getStackInSlot(78).m_41619_() && inventoryIn.getStackInSlot(79).m_41619_() && inventoryIn.getStackInSlot(80).m_41619_() && inventoryIn.getStackInSlot(81).m_41619_() && inventoryIn.getStackInSlot(82).m_41619_() && inventoryIn.getStackInSlot(83).m_41619_() && inventoryIn.getStackInSlot(84).m_41619_() && inventoryIn.getStackInSlot(85).m_41619_() && inventoryIn.getStackInSlot(86).m_41619_() && inventoryIn.getStackInSlot(87).m_41619_() && inventoryIn.getStackInSlot(88).m_41619_() && inventoryIn.getStackInSlot(89).m_41619_() && inventoryIn.getStackInSlot(90).m_41619_())) {
            hasItems = true;
        }
        return hasItems;
    }

    public void dropInventoryContentsStorageSlot9() {
        if (this.inventory.getStackInSlot(9).m_41619_() && this.areItemsInStorageSlot9Range(this.inventory)) {
            SimpleContainer inventoryIn = new SimpleContainer(this.inventory.getSlots());
            for (int i = 91; i <= 117; ++i) {
                inventoryIn.m_6836_(i, this.inventory.getStackInSlot(i));
            }
            Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)inventoryIn);
        }
    }

    private boolean areItemsInStorageSlot9Range(ItemStackHandler inventoryIn) {
        boolean hasItems = false;
        if (!(inventoryIn.getStackInSlot(91).m_41619_() && inventoryIn.getStackInSlot(92).m_41619_() && inventoryIn.getStackInSlot(93).m_41619_() && inventoryIn.getStackInSlot(94).m_41619_() && inventoryIn.getStackInSlot(95).m_41619_() && inventoryIn.getStackInSlot(96).m_41619_() && inventoryIn.getStackInSlot(97).m_41619_() && inventoryIn.getStackInSlot(98).m_41619_() && inventoryIn.getStackInSlot(99).m_41619_() && inventoryIn.getStackInSlot(100).m_41619_() && inventoryIn.getStackInSlot(101).m_41619_() && inventoryIn.getStackInSlot(102).m_41619_() && inventoryIn.getStackInSlot(103).m_41619_() && inventoryIn.getStackInSlot(104).m_41619_() && inventoryIn.getStackInSlot(105).m_41619_() && inventoryIn.getStackInSlot(106).m_41619_() && inventoryIn.getStackInSlot(107).m_41619_() && inventoryIn.getStackInSlot(108).m_41619_() && inventoryIn.getStackInSlot(109).m_41619_() && inventoryIn.getStackInSlot(110).m_41619_() && inventoryIn.getStackInSlot(111).m_41619_() && inventoryIn.getStackInSlot(112).m_41619_() && inventoryIn.getStackInSlot(113).m_41619_() && inventoryIn.getStackInSlot(114).m_41619_() && inventoryIn.getStackInSlot(115).m_41619_() && inventoryIn.getStackInSlot(116).m_41619_() && inventoryIn.getStackInSlot(117).m_41619_())) {
            hasItems = true;
        }
        return hasItems;
    }

    public void IsStorageChestInSlot1() {
        if (!this.inventory.getStackInSlot(1).m_41619_() && !this.getStatusItemInSlot1()) {
            this.setStatusItemInSlot1(true);
        }
        if (this.inventory.getStackInSlot(1).m_41619_() && this.getStatusItemInSlot1()) {
            this.setStatusItemInSlot1(false);
        }
    }

    public void IsStorageChestInSlot6() {
        if (!this.inventory.getStackInSlot(6).m_41619_() && !this.getStatusItemInSlot6()) {
            this.setStatusItemInSlot6(true);
        }
        if (this.inventory.getStackInSlot(6).m_41619_() && this.getStatusItemInSlot6()) {
            this.setStatusItemInSlot6(false);
        }
    }

    public void IsStorageChestInSlot7() {
        if (!this.inventory.getStackInSlot(7).m_41619_() && !this.getStatusItemInSlot7()) {
            this.setStatusItemInSlot7(true);
        }
        if (this.inventory.getStackInSlot(7).m_41619_() && this.getStatusItemInSlot7()) {
            this.setStatusItemInSlot7(false);
        }
    }

    public void IsStorageChestInSlot8() {
        if (!this.inventory.getStackInSlot(8).m_41619_() && !this.getStatusItemInSlot8()) {
            this.setStatusItemInSlot8(true);
        }
        if (this.inventory.getStackInSlot(8).m_41619_() && this.getStatusItemInSlot8()) {
            this.setStatusItemInSlot8(false);
        }
    }

    public void IsStorageChestInSlot9() {
        if (!this.inventory.getStackInSlot(9).m_41619_() && !this.getStatusItemInSlot9()) {
            this.setStatusItemInSlot9(true);
        }
        if (this.inventory.getStackInSlot(9).m_41619_() && this.getStatusItemInSlot9()) {
            this.setStatusItemInSlot9(false);
        }
    }

    protected float ReducedSpeedMultiplier() {
        float adjustedspeed = 1.0f;
        if (this.getMachineType() != MachineType.HAULER && (this.getStatusItemInSlot6() || this.getStatusItemInSlot7() || this.getStatusItemInSlot8() || this.getStatusItemInSlot9())) {
            adjustedspeed = 0.75f;
        }
        return adjustedspeed;
    }
}

