/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.utils;

import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class HSLColor {
    public static int getProcessedColor(int rgb) {
        float[] hsl = HSLColor.rgbToHsl(rgb);
        hsl = HSLColor.postProcess(hsl);
        float h = hsl[0];
        float s = hsl[1];
        float l = hsl[2];
        return HSLColor.hslToRgb(h, s *= 0.81f, l);
    }

    public static float[] postProcess(float[] hsl) {
        float h = hsl[0];
        float s = hsl[1];
        float l = hsl[2];
        float c = 1.0f - Math.abs(2.0f * l - 1.0f);
        if (s > c) {
            s = c;
        }
        float minLightness = 0.47f;
        l = Math.max(l, minLightness);
        float j = 1.0f - l;
        float scaling = 0.15f;
        float angle = 90.0f;
        float n = (float)((double)scaling * Math.exp((double)(-angle) * Math.pow(h - 0.6666f, 2.0)));
        return new float[]{h, s -= n, l};
    }

    public static int hslToRgb(float h, float s, float l) {
        float r;
        float g;
        float b;
        if (s == 0.0f) {
            g = b = l;
            r = b;
        } else {
            float q = l < 0.5f ? l * (1.0f + s) : l + s - l * s;
            float p = 2.0f * l - q;
            r = HSLColor.hueToRgb(p, q, h + 0.33333334f);
            g = HSLColor.hueToRgb(p, q, h);
            b = HSLColor.hueToRgb(p, q, h - 0.33333334f);
        }
        return FastColor.ARGB32.m_13660_((int)Mth.m_14143_((float)255.0f), (int)Mth.m_14143_((float)(r * 255.0f)), (int)Mth.m_14143_((float)(g * 255.0f)), (int)Mth.m_14143_((float)(b * 255.0f)));
    }

    public static float hueToRgb(float p, float q, float t) {
        if (t < 0.0f) {
            t += 1.0f;
        }
        if (t > 1.0f) {
            t -= 1.0f;
        }
        if (t < 0.16666667f) {
            return p + (q - p) * 6.0f * t;
        }
        if (t < 0.5f) {
            return q;
        }
        if (t < 0.6666667f) {
            return p + (q - p) * (0.6666667f - t) * 6.0f;
        }
        return p;
    }

    public static float[] rgbToHsl(int rgb) {
        int r = FastColor.ARGB32.m_13665_((int)rgb);
        int g = FastColor.ARGB32.m_13667_((int)rgb);
        int b = FastColor.ARGB32.m_13669_((int)rgb);
        return HSLColor.rgbToHsl(r, g, b);
    }

    public static float[] rgbToHsl(int pR, int pG, int pB) {
        float h;
        float s;
        float r = (float)pR / 255.0f;
        float g = (float)pG / 255.0f;
        float b = (float)pB / 255.0f;
        float max = r > g && r > b ? r : Math.max(g, b);
        float min = r < g && r < b ? r : Math.min(g, b);
        float l = (max + min) / 2.0f;
        if (max == min) {
            s = 0.0f;
            h = 0.0f;
        } else {
            float d = max - min;
            float f = s = l > 0.5f ? d / (2.0f - max - min) : d / (max + min);
            h = r > g && r > b ? (g - b) / d + (g < b ? 6.0f : 0.0f) : (g > b ? (b - r) / d + 2.0f : (r - g) / d + 4.0f);
            h /= 6.0f;
        }
        return new float[]{h, s, l};
    }
}

