/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.zapper;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.curiosities.zapper.PlacementPatterns;
import com.simibubi.create.content.curiosities.zapper.ShootableGadgetItemMethods;
import com.simibubi.create.content.curiosities.zapper.ZapperBeamPacket;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.NBTProcessors;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public abstract class ZapperItem
extends Item {
    public ZapperItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("BlockUsed")) {
            MutableComponent usedBlock = NbtUtils.m_129241_((CompoundTag)stack.m_41783_().m_128469_("BlockUsed")).m_60734_().m_49954_();
            ItemDescription.add(tooltip, (Component)Lang.translateDirect("terrainzapper.usingBlock", usedBlock.m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        boolean differentBlock = false;
        if (oldStack.m_41782_() && newStack.m_41782_() && oldStack.m_41783_().m_128441_("BlockUsed") && newStack.m_41783_().m_128441_("BlockUsed")) {
            differentBlock = NbtUtils.m_129241_((CompoundTag)oldStack.m_41783_().m_128469_("BlockUsed")) != NbtUtils.m_129241_((CompoundTag)newStack.m_41783_().m_128469_("BlockUsed"));
        }
        return slotChanged || !this.isZapper(newStack) || differentBlock;
    }

    public boolean isZapper(ItemStack newStack) {
        return newStack.m_41720_() instanceof ZapperItem;
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_() != null && context.m_43723_().m_6144_()) {
            if (context.m_43725_().f_46443_) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.openHandgunGUI(context.m_43722_(), context.m_43724_()));
                context.m_43723_().m_36335_().m_41524_(context.m_43722_().m_41720_(), 10);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        boolean mainHand;
        ItemStack item = player.m_21120_(hand);
        CompoundTag nbt = item.m_41784_();
        boolean bl = mainHand = hand == InteractionHand.MAIN_HAND;
        if (player.m_6144_()) {
            if (world.f_46443_) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.openHandgunGUI(item, hand));
                player.m_36335_().m_41524_(item.m_41720_(), 10);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)item);
        }
        if (ShootableGadgetItemMethods.shouldSwap(player, item, hand, this::isZapper)) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)item);
        }
        Component msg = this.validateUsage(item);
        if (msg != null) {
            AllSoundEvents.DENY.play(world, player, (Vec3i)player.m_142538_());
            player.m_5661_((Component)msg.m_6879_().m_130940_(ChatFormatting.RED), true);
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)item);
        }
        BlockState stateToUse = Blocks.f_50016_.m_49966_();
        if (nbt.m_128441_("BlockUsed")) {
            stateToUse = NbtUtils.m_129241_((CompoundTag)nbt.m_128469_("BlockUsed"));
        }
        stateToUse = BlockHelper.setZeroAge(stateToUse);
        CompoundTag data = null;
        if (AllTags.AllBlockTags.SAFE_NBT.matches(stateToUse) && nbt.m_128425_("BlockData", 10)) {
            data = nbt.m_128469_("BlockData");
        }
        Vec3 start = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
        Vec3 range = player.m_20154_().m_82490_((double)this.getZappingRange(item));
        BlockHitResult raytrace = world.m_45547_(new ClipContext(start, start.m_82549_(range), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        BlockPos pos = raytrace.m_82425_();
        BlockState stateReplaced = world.m_8055_(pos);
        if (pos == null || stateReplaced.m_60734_() == Blocks.f_50016_) {
            ShootableGadgetItemMethods.applyCooldown(player, item, hand, this::isZapper, this.getCooldownDelay(item));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)item);
        }
        Vec3 barrelPos = ShootableGadgetItemMethods.getGunBarrelVec(player, mainHand, new Vec3((double)0.35f, (double)-0.1f, 1.0));
        if (world.f_46443_) {
            CreateClient.ZAPPER_RENDER_HANDLER.dontAnimateItem(hand);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)item);
        }
        if (this.activate(world, player, item, stateToUse, raytrace, data)) {
            ShootableGadgetItemMethods.applyCooldown(player, item, hand, this::isZapper, this.getCooldownDelay(item));
            ShootableGadgetItemMethods.sendPackets(player, b -> new ZapperBeamPacket(barrelPos, raytrace.m_82450_(), hand, (boolean)b));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)item);
    }

    public Component validateUsage(ItemStack item) {
        CompoundTag tag = item.m_41784_();
        if (!this.canActivateWithoutSelectedBlock(item) && !tag.m_128441_("BlockUsed")) {
            return Lang.translateDirect("terrainzapper.leftClickToSet", new Object[0]);
        }
        return null;
    }

    protected abstract boolean activate(Level var1, Player var2, ItemStack var3, BlockState var4, BlockHitResult var5, CompoundTag var6);

    @OnlyIn(value=Dist.CLIENT)
    protected abstract void openHandgunGUI(ItemStack var1, InteractionHand var2);

    protected abstract int getCooldownDelay(ItemStack var1);

    protected abstract int getZappingRange(ItemStack var1);

    protected boolean canActivateWithoutSelectedBlock(ItemStack stack) {
        return false;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public boolean m_6777_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return false;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public static void configureSettings(ItemStack stack, PlacementPatterns pattern) {
        CompoundTag nbt = stack.m_41784_();
        NBTHelper.writeEnum(nbt, "Pattern", pattern);
    }

    public static void setTileData(Level world, BlockPos pos, BlockState state, CompoundTag data, Player player) {
        BlockEntity tile;
        if (data != null && AllTags.AllBlockTags.SAFE_NBT.matches(state) && (tile = world.m_7702_(pos)) != null) {
            if ((data = NBTProcessors.process(tile, data, !player.m_7500_())) == null) {
                return;
            }
            data.m_128405_("x", pos.m_123341_());
            data.m_128405_("y", pos.m_123342_());
            data.m_128405_("z", pos.m_123343_());
            tile.m_142466_(data);
        }
    }
}

