/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.energy.network;

import com.mrh0.createaddition.energy.network.EnergyNetwork;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.level.LevelAccessor;

public class EnergyNetworkManager {
    public static Map<LevelAccessor, EnergyNetworkManager> instances = new HashMap<LevelAccessor, EnergyNetworkManager>();
    private List<EnergyNetwork> networks;

    public EnergyNetworkManager(LevelAccessor world) {
        instances.put(world, this);
        this.networks = new ArrayList<EnergyNetwork>();
    }

    public void add(EnergyNetwork network) {
        this.networks.add(network);
    }

    public void tick() {
        ArrayList<EnergyNetwork> keep = new ArrayList<EnergyNetwork>();
        for (int i = 0; i < this.networks.size(); ++i) {
            EnergyNetwork en = this.networks.get(i);
            if (en.isValid()) {
                en.tick();
                keep.add(en);
                continue;
            }
            en.removed();
        }
        this.networks = keep;
    }

    public static void tickWorld(LevelAccessor world) {
        if (instances == null) {
            return;
        }
        if (instances.get(world) == null) {
            return;
        }
        instances.get(world).tick();
    }
}

