/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.registry.forge;

import com.mojang.datafixers.util.Pair;
import earth.terrarium.chipped.registry.RegistryHelpers;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class RegistryHelpersImpl {
    public static final Map<Registry<?>, DeferredRegister<?>> REGISTRIES = new HashMap();

    public static <T extends AbstractContainerMenu> MenuType<T> createMenuType(RegistryHelpers.MenuFactory<T> factory) {
        return IForgeMenuType.create(factory::create);
    }

    public static <E extends BlockEntity> BlockEntityType<E> createBlockEntityType(RegistryHelpers.BlockEntityFactory<E> factory, Block ... blocks) {
        return BlockEntityType.Builder.m_155273_(factory::create, (Block[])blocks).m_58966_(null);
    }

    public static CreativeModeTab createTab(ResourceLocation loc, final Supplier<ItemStack> icon) {
        return new CreativeModeTab(loc.m_135827_() + "." + loc.m_135815_()){

            @NotNull
            public ItemStack m_6976_() {
                return (ItemStack)icon.get();
            }
        };
    }

    public static <T> DeferredRegister<T> getOrCreateRegistry(Registry<T> registry) {
        if (REGISTRIES.containsKey(registry)) {
            return REGISTRIES.get(registry);
        }
        DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)registry.m_123023_(), (String)"chipped");
        REGISTRIES.put(registry, deferredRegister);
        return deferredRegister;
    }

    public static <V, T extends V> Pair<Supplier<T>, ResourceLocation> registerFull(Registry<V> registry, String id, Supplier<T> object) {
        RegistryObject registered = RegistryHelpersImpl.getOrCreateRegistry(registry).register(id, object);
        return Pair.of((Object)registered, (Object)registered.getId());
    }
}

