/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.mixin;

import net.minecraft.core.Registry;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TextureMapping.class})
public abstract class TextureMappingMixin {
    @Inject(method={"getBlockTexture(Lnet/minecraft/world/level/block/Block;)Lnet/minecraft/resources/ResourceLocation;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getBlockTexture(Block block, CallbackInfoReturnable<ResourceLocation> ci) {
        ResourceLocation resourceLocation = Registry.f_122824_.m_7981_((Object)block);
        String name = resourceLocation.m_135827_();
        if (name.contains("chipped")) {
            String path = resourceLocation.m_135815_();
            String directory = StringUtils.substringBeforeLast((String)path, (String)"_");
            ci.setReturnValue((Object)new ResourceLocation(resourceLocation.m_135827_(), "block/" + directory + "/" + resourceLocation.m_135815_()));
        }
    }

    @Inject(method={"getBlockTexture(Lnet/minecraft/world/level/block/Block;Ljava/lang/String;)Lnet/minecraft/resources/ResourceLocation;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getBlockTexture(Block block, String textureSuffix, CallbackInfoReturnable<ResourceLocation> ci) {
        ResourceLocation resourceLocation = Registry.f_122824_.m_7981_((Object)block);
        String name = resourceLocation.m_135827_();
        if (name.contains("chipped")) {
            String path = resourceLocation.m_135815_();
            String directory = StringUtils.substringBeforeLast((String)path, (String)"_");
            ci.setReturnValue((Object)new ResourceLocation(name, "block/" + directory + "/" + path + textureSuffix));
        }
    }

    @Inject(method={"getItemTexture(Lnet/minecraft/world/item/Item;)Lnet/minecraft/resources/ResourceLocation;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getItemTexture(Item item, CallbackInfoReturnable<ResourceLocation> ci) {
        ResourceLocation resourceLocation = Registry.f_122827_.m_7981_((Object)item);
        String name = resourceLocation.m_135827_();
        if (name.contains("chipped")) {
            String path = resourceLocation.m_135815_();
            String directory = StringUtils.substringBeforeLast((String)path, (String)"_");
            ci.setReturnValue((Object)new ResourceLocation(resourceLocation.m_135827_(), "item/" + directory + "/" + resourceLocation.m_135815_()));
        }
    }

    @Inject(method={"getItemTexture(Lnet/minecraft/world/item/Item;Ljava/lang/String;)Lnet/minecraft/resources/ResourceLocation;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getItemTexture(Item item, String textureSuffix, CallbackInfoReturnable<ResourceLocation> ci) {
        ResourceLocation resourceLocation = Registry.f_122827_.m_7981_((Object)item);
        String name = resourceLocation.m_135827_();
        if (name.contains("chipped")) {
            String path = resourceLocation.m_135815_();
            String directory = StringUtils.substringBeforeLast((String)path, (String)"_");
            ci.setReturnValue((Object)new ResourceLocation(name, "item/" + directory + "/" + path + textureSuffix));
        }
    }
}

