/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render.model;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.client.render.box.RenderBox;
import team.creative.creativecore.client.render.model.CreativeBakedBoxModel;
import team.creative.creativecore.client.render.model.CreativeBakedModel;
import team.creative.creativecore.client.render.model.CreativeBlockModel;
import team.creative.creativecore.client.render.model.CreativeItemModel;
import team.creative.creativecore.common.util.math.base.Facing;

@OnlyIn(value=Dist.CLIENT)
public abstract class CreativeItemBoxModel
extends CreativeItemModel {
    public static final Minecraft mc = Minecraft.m_91087_();
    public static final List<RenderType> STANDARD = List.of(Sheets.m_110790_());
    public static final List<RenderType> ADVANCED = List.of(Sheets.m_110790_(), Sheets.m_110792_());
    public static final CreativeItemBoxModel EMPTY = new CreativeItemBoxModel(new ModelResourceLocation("minecraft", "stone", "inventory")){

        @Override
        public List<? extends RenderBox> getBoxes(ItemStack stack, RenderType layer) {
            return Collections.EMPTY_LIST;
        }
    };

    public CreativeItemBoxModel(ModelResourceLocation location) {
        super(location);
    }

    public abstract List<? extends RenderBox> getBoxes(ItemStack var1, RenderType var2);

    public List<RenderType> getLayers(ItemStack stack, boolean fabulous) {
        if (this.hasTranslucentLayer(stack)) {
            return ADVANCED;
        }
        return STANDARD;
    }

    public boolean hasTranslucentLayer(ItemStack stack) {
        return false;
    }

    public List<BakedQuad> getCachedModel(Facing facing, RenderType layer, ItemStack stack, boolean threaded) {
        return null;
    }

    public void saveCachedModel(Facing facing, RenderType layer, List<BakedQuad> cachedQuads, ItemStack stack, boolean threaded) {
    }

    public void reload() {
    }

    @Override
    public CreativeBakedModel create(CreativeBlockModel block) {
        return new CreativeBakedBoxModel(this.location, this, block);
    }
}

