/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.CommonMath;
import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import com.endertech.minecraft.mods.adpother.pollution.GasChain;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class GasExplosion {
    public static int maxChainLength = 512;
    protected Level world;
    protected Iterable<BlockPos> positions = Collections.emptyList();
    protected Consumer<? super GasChain> action = chain -> {};

    protected GasExplosion(Level world) {
        this.world = world;
    }

    public static GasExplosion in(Level world) {
        return new GasExplosion(world);
    }

    public GasExplosion position(BlockPos position) {
        return this.positions(Collections.singleton(position));
    }

    public GasExplosion positions(Iterable<BlockPos> positions) {
        this.positions = positions;
        return this;
    }

    public GasExplosion action(Consumer<? super GasChain> action) {
        this.action = action;
        return this;
    }

    public boolean tryTrigger() {
        for (BlockPos pos : this.positions) {
            AbstractGas gas;
            BlockState state = this.world.m_8055_(pos);
            Block block = state.m_60734_();
            if (!(block instanceof AbstractGas) || (gas = (AbstractGas)block).getLowerExplosiveLimit() <= 0 || gas.affectsPollutionLevel((LevelAccessor)this.world, pos, state)) continue;
            GasChain chain = new GasChain((LevelAccessor)this.world, pos, gas, gas.getLowerExplosiveLimit());
            chain.build();
            if (chain.getFound().size() < gas.getLowerExplosiveLimit()) continue;
            this.action.accept(chain);
            return true;
        }
        return false;
    }

    public boolean tryExplode() {
        return this.action(GasExplosion::explode).tryTrigger();
    }

    public static void explode(GasChain fuseChain) {
        LevelAccessor world = fuseChain.getWorld();
        GasChain fullChain = new GasChain(world, fuseChain.getStartPos(), fuseChain.getGas(), maxChainLength);
        fullChain.build();
        int maxExplosions = (int)Math.max(1.0, CommonMath.raiseToPower((double)fullChain.length(), (double)0.3333333333333333));
        int maxExplosionSize = (int)Math.sqrt(fullChain.length());
        int step = Math.max(1, fullChain.length() / maxExplosions);
        HashMap<BlockPos, Float> explosions = new HashMap<BlockPos, Float>(maxExplosions + 1, 1.0f);
        for (int i = 0; i < fullChain.length(); i += step) {
            float explosionSize = 0.0f;
            BlockPos centerPos = (BlockPos)fullChain.getChain().get(i);
            for (BlockPos pos2 : GameWorld.Positions.getAroundHoriz((BlockPos)centerPos, (boolean)false, (BlockPos[])new BlockPos[]{centerPos.m_7494_(), centerPos.m_7495_(), centerPos})) {
                BlockState state = world.m_8055_(pos2);
                if (!((explosionSize += (float)fullChain.getGas().getCarriedPollutionAmount(state)) >= (float)maxExplosionSize)) continue;
                explosionSize = maxExplosionSize;
                break;
            }
            if (!(explosionSize > 0.0f)) continue;
            explosions.put(centerPos, Float.valueOf(explosionSize));
        }
        if (world instanceof ServerLevel) {
            fullChain.getChain().forEach(pos -> world.m_7471_(pos, false));
            explosions.forEach((pos, size) -> GameWorld.scheduleBlockExplosion((ServerLevel)((ServerLevel)world), (BlockPos)pos, (CommonTime.Interval)CommonTime.Interval.ZERO, (float)size.floatValue(), (boolean)true, (Explosion.BlockInteraction)Explosion.BlockInteraction.BREAK, (boolean)false, null));
        }
    }

    public static GasExplosion fromHeldTorch(Player player) {
        GasExplosion explosion = GasExplosion.in(player.f_19853_);
        Set<InteractionHand> hands = GasExplosion.getTorchHoldingHands(player);
        return hands.isEmpty() ? explosion : explosion.positions(GasExplosion.getIgnitablePositionsAround(player, hands));
    }

    public static List<BlockPos> getIgnitablePositionsAround(Player player, Set<InteractionHand> hands) {
        Direction face = player.m_6350_();
        BlockPos eyes = ForgeEntity.getPositionEyes((Entity)player);
        BlockPos body = eyes.m_7495_();
        ArrayList positions = Lists.newArrayList((Object[])new BlockPos[]{eyes.m_7494_(), eyes.m_142300_(face), body.m_142300_(face)});
        for (InteractionHand hand : hands) {
            Direction facing = hand == InteractionHand.MAIN_HAND ? face.m_122427_() : face.m_122428_();
            positions.add(eyes.m_142300_(facing));
            positions.add(body.m_142300_(facing));
        }
        positions.add(eyes);
        positions.add(body);
        return positions;
    }

    public static Set<InteractionHand> getTorchHoldingHands(Player player) {
        EnumSet<InteractionHand> hands = EnumSet.noneOf(InteractionHand.class);
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = player.m_21120_(hand);
            AdPother.getInstance().torches.get(stack).ifPresent(torch -> hands.add(hand));
        }
        return hands;
    }
}

