/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.minecraft.mods.adpother.entities.AbstractCarrier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class CarrierSpawnLimiter<C extends AbstractCarrier> {
    public static int maxTotalQuantity = 64;
    private final Set<C> carriers = new HashSet<C>();
    private long lastSpawn = 0L;

    public boolean canSpawnAt(Level world, BlockPos pos) {
        long time = world.m_46467_();
        return time != this.lastSpawn && this.carriers.size() < maxTotalQuantity;
    }

    public void add(C carrier) {
        this.carriers.add(carrier);
        this.lastSpawn = ((AbstractCarrier)((Object)carrier)).f_19853_.m_46467_();
    }

    public void remove(C carrier) {
        this.carriers.remove(carrier);
        Level level = carrier.m_183503_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            this.carriers.removeIf(c -> !level2.m_143340_(c.m_142538_()));
        }
    }

    public Set<C> getCarriers() {
        return Collections.unmodifiableSet(this.carriers);
    }

    public int count(Predicate<C> predicate) {
        return this.carriers.stream().filter(predicate).mapToInt(c -> 1).sum();
    }
}

