/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.emissions;

import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.mods.adpother.emissions.AbstractEntityEmission;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;

public class PeriodicEntityEmission
extends AbstractEntityEmission<Entity, Emitter> {
    public static float rate = 1.0f;

    protected PeriodicEntityEmission(Entity entity, Emitter emitter, GameTime updateInterval) {
        super(entity, emitter, updateInterval);
    }

    public static PeriodicEntityEmission of(Entity entity, Emitter emitter) {
        return new PeriodicEntityEmission(entity, emitter, GameTime.second());
    }

    public boolean isEntityDeadOrRemoved() {
        Entity entity = (Entity)this.getEntity();
        if (!entity.m_6084_()) {
            return true;
        }
        return !entity.isAddedToWorld();
    }

    @Override
    public BlockPos getEntityBlockPos() {
        return ((Entity)this.getEntity()).m_142538_();
    }

    public void onUpdate() {
        Emitter emitter;
        if (this.isEntityDeadOrRemoved()) {
            this.kill();
            return;
        }
        if (this.isInEntityTickingChunk() && (emitter = (Emitter)((Object)this.getEmitter())).isActive((INBTSerializable<CompoundTag>)((INBTSerializable)this.getEntity()))) {
            float factor = 1.0f;
            if (!emitter.hasSeparateRateControl()) {
                factor *= rate;
            }
            emitter.emitAt(this.getWorldLevel(), this.getEntityBlockPos(), factor);
        }
    }

    @Nullable
    public Level getWorldLevel() {
        return ((Entity)this.getEntity()).f_19853_;
    }
}

