/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.common.fluids.PotionFluid;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.register.IEItems;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionBucketItem
extends IEBaseItem {
    public PotionBucketItem() {
        super(new Item.Properties().m_41487_(1), CreativeModeTab.f_40758_);
    }

    public static ItemStack forPotion(Potion type) {
        if (type == Potions.f_43599_ || type == null) {
            return new ItemStack((ItemLike)Items.f_42447_);
        }
        ItemStack result = new ItemStack(IEItems.Misc.POTION_BUCKET);
        result.m_41784_().m_128359_("Potion", type.getRegistryName().toString());
        return result;
    }

    public static Potion getPotion(ItemStack stack) {
        return PotionFluid.fromTag(stack.m_41783_());
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (!this.m_41389_(group)) {
            return;
        }
        ArrayList<Potion> sortedPotions = new ArrayList<Potion>(ForgeRegistries.POTIONS.getValues());
        sortedPotions.sort(Comparator.comparing(e -> PotionBucketItem.getPotionName(e).getString()));
        for (Potion p : sortedPotions) {
            if (p == Potions.f_43599_) continue;
            items.add((Object)PotionBucketItem.forPotion(p));
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluidHandler(stack);
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        return new TranslatableComponent("item.immersiveengineering.potion_bucket", new Object[]{PotionBucketItem.getPotionName(PotionBucketItem.getPotion(stack))});
    }

    private static Component getPotionName(Potion potion) {
        String potionKey = potion.m_43492_(Items.f_42589_.m_5524_() + ".effect.");
        return new TranslatableComponent(potionKey);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level worldIn, @Nonnull Player playerIn, @Nonnull InteractionHand handIn) {
        BlockHitResult rayTraceResult = PotionBucketItem.m_41435_((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        ItemStack stack = playerIn.m_21120_(handIn);
        InteractionResultHolder forgeResult = ForgeEventFactory.onBucketUse((Player)playerIn, (Level)worldIn, (ItemStack)stack, (HitResult)rayTraceResult);
        if (forgeResult != null) {
            return forgeResult;
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        PotionUtils.m_43555_((ItemStack)stack, tooltip, (float)1.0f);
    }

    private static class FluidHandler
    implements IFluidHandlerItem,
    ICapabilityProvider {
        private final ItemStack stack;
        private boolean empty = false;
        private final LazyOptional<IFluidHandlerItem> lazyOpt = CapabilityUtils.constantOptional(this);

        private FluidHandler(ItemStack stack) {
            this.stack = stack;
        }

        private FluidStack getFluid() {
            if (this.empty) {
                return FluidStack.EMPTY;
            }
            return PotionFluid.getFluidStackForType(PotionBucketItem.getPotion(this.stack), 1000);
        }

        @Nonnull
        public ItemStack getContainer() {
            return this.empty ? new ItemStack((ItemLike)Items.f_42446_) : this.stack;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            if (tank == 0) {
                return this.getFluid();
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return tank == 0 ? 1000 : 0;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            FluidStack fluid = this.getFluid();
            if (!fluid.isFluidEqual(resource) || !Objects.equals(fluid.getTag(), resource.getTag())) {
                return FluidStack.EMPTY;
            }
            return this.drain(resource.getAmount(), action);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (this.empty || this.stack.m_41613_() > 1 || maxDrain < 1000) {
                return FluidStack.EMPTY;
            }
            FluidStack potion = this.getFluid();
            if (action.execute()) {
                this.empty = true;
            }
            return potion;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                return this.lazyOpt.cast();
            }
            return LazyOptional.empty();
        }
    }
}

