/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.api.crafting.FermenterRecipe;
import blusunrize.immersiveengineering.api.crafting.SqueezerRecipe;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.energy.ThermoelectricSource;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.client.manual.IEManualInstance;
import blusunrize.immersiveengineering.client.manual.ManualElementBlueprint;
import blusunrize.immersiveengineering.client.manual.ManualElementBottling;
import blusunrize.immersiveengineering.client.manual.ManualElementMixer;
import blusunrize.immersiveengineering.client.manual.ManualElementMultiblock;
import blusunrize.immersiveengineering.client.manual.ShaderManualElement;
import blusunrize.immersiveengineering.common.register.IEFluids;
import blusunrize.lib.manual.ManualElementItem;
import blusunrize.lib.manual.ManualElementTable;
import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.Tree;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class IEManual {
    public static void initManual() {
        IEManualInstance ieMan = new IEManualInstance();
        ManualHelper.IE_MANUAL_INSTANCE.setValue(ieMan);
        ManualHelper.ADD_CONFIG_GETTER.setValue(e -> {
            List<Function<String, Object>> list = ieMan.configGetters;
            synchronized (list) {
                ieMan.configGetters.add((Function<String, Object>)e);
            }
        });
        ManualHelper.DYNAMIC_TABLES.put("squeezer", () -> IEManual.formatToTable_ItemIntMap(SqueezerRecipe.getFluidValuesSorted((Level)Minecraft.m_91087_().f_91073_, (Fluid)IEFluids.PLANTOIL.getStill(), true), "mB"));
        ManualHelper.DYNAMIC_TABLES.put("fermenter", () -> IEManual.formatToTable_ItemIntMap(FermenterRecipe.getFluidValuesSorted((Level)Minecraft.m_91087_().f_91073_, (Fluid)IEFluids.ETHANOL.getStill(), true), "mB"));
        ManualHelper.DYNAMIC_TABLES.put("thermoelectric", () -> IEManual.formatToTable_ItemIntMap(ThermoelectricSource.getThermalValuesSorted((Level)Minecraft.m_91087_().f_91073_, true), "K"));
        ieMan.registerSpecialElement(new ResourceLocation("immersiveengineering", "blueprint"), s -> new ManualElementBlueprint(ieMan, IEManual.collectRecipeStacksFromJSON(s)));
        ieMan.registerSpecialElement(new ResourceLocation("immersiveengineering", "bottling"), s -> new ManualElementBottling(ieMan, IEManual.collectRecipeStacksFromJSON(s)));
        ieMan.registerSpecialElement(new ResourceLocation("immersiveengineering", "mixer"), s -> new ManualElementMixer((ManualInstance)ieMan, IEManual.collectRecipeFluidsFromJSON(s)));
        ieMan.registerSpecialElement(new ResourceLocation("immersiveengineering", "multiblock"), s -> {
            ResourceLocation name = ManualUtils.getLocationForManual(GsonHelper.m_13906_((JsonObject)s, (String)"name"), ieMan);
            MultiblockHandler.IMultiblock mb = MultiblockHandler.getByUniqueName(name);
            if (mb == null) {
                throw new NullPointerException("Multiblock " + name + " does not exist");
            }
            return new ManualElementMultiblock(ieMan, mb);
        });
        ieMan.registerSpecialElement(new ResourceLocation("immersiveengineering", "dynamic_table"), s -> new ManualElementTable(ManualHelper.getManual(), ManualHelper.DYNAMIC_TABLES.get(GsonHelper.m_13906_((JsonObject)s, (String)"table")).get(), false));
    }

    public static void addIEManualEntries() {
        IEManualInstance ieMan = (IEManualInstance)ManualHelper.getManual();
        Tree.InnerNode<ResourceLocation, ManualEntry> generalCat = ieMan.getRoot().getOrCreateSubnode(new ResourceLocation("immersiveengineering", ManualHelper.CAT_GENERAL), 0);
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
        builder.readFromFile(new ResourceLocation("immersiveengineering", "minerals"));
        builder.appendText(IEManual::getMineralVeinTexts);
        ieMan.addEntry(generalCat, builder.create(), ieMan.atOffsetFrom(generalCat, "graphite", -0.5));
        ieMan.hideEntry(new ResourceLocation("immersiveengineering", "blueprints"));
        builder = new ManualEntry.ManualEntryBuilder(ieMan);
        builder.setContent(() -> "Shader list", () -> "", () -> {
            StringBuilder content = new StringBuilder();
            for (ShaderRegistry.ShaderRegistryEntry shader : ShaderRegistry.shaderRegistry.values()) {
                String key = shader.name.m_135815_();
                content.append("<&").append(key).append(">").append("<np>");
            }
            int last = content.lastIndexOf("<np>");
            content.delete(last, last + 4);
            return content.toString();
        });
        for (ShaderRegistry.ShaderRegistryEntry shader : ShaderRegistry.shaderRegistry.values()) {
            String key = shader.name.m_135815_();
            builder.addSpecialElement(new ManualEntry.SpecialElementData(key, 0, new ShaderManualElement(ieMan, shader)));
        }
        builder.setLocation(new ResourceLocation("immersiveengineering", "shader_list"));
        ManualEntry e = builder.create();
        ieMan.addEntry(generalCat, e);
        ieMan.hideEntry(e.getLocation());
        IEManual.addChangelogToManual();
    }

    private static Pair<String, List<ManualEntry.SpecialElementData>> getMineralVeinTexts() {
        StringBuilder text = new StringBuilder();
        ArrayList<ManualEntry.SpecialElementData> specials = new ArrayList<ManualEntry.SpecialElementData>();
        ArrayList<MineralMix> mineralsToAdd = new ArrayList<MineralMix>(MineralMix.RECIPES.getRecipes((Level)Minecraft.m_91087_().f_91073_));
        Function<MineralMix, String> toName = mineral -> {
            String translationKey = mineral.getTranslationKey();
            String localizedName = I18n.m_118938_((String)translationKey, (Object[])new Object[0]);
            if (localizedName.equals(translationKey)) {
                localizedName = mineral.getPlainName();
            }
            return localizedName;
        };
        mineralsToAdd.sort((i1, i2) -> ((String)toName.apply((MineralMix)i1)).compareToIgnoreCase((String)toName.apply((MineralMix)i2)));
        for (MineralMix mineral2 : mineralsToAdd) {
            Object sorted2;
            String dimensionString;
            if (mineral2.dimensions != null && mineral2.dimensions.size() > 0) {
                StringBuilder validDims = new StringBuilder();
                for (ResourceKey dim : mineral2.dimensions) {
                    validDims.append(validDims.length() > 0 ? ", " : "").append("<dim;").append(dim.m_135782_()).append(">");
                }
                dimensionString = I18n.m_118938_((String)"ie.manual.entry.mineralsDimValid", (Object[])new Object[]{toName.apply(mineral2), validDims.toString()});
            } else {
                dimensionString = I18n.m_118938_((String)"ie.manual.entry.mineralsDimAny", (Object[])new Object[]{toName.apply(mineral2)});
            }
            List<StackWithChance> formattedOutputs = Arrays.asList(mineral2.outputs);
            List<StackWithChance> formattedSpoils = Arrays.asList(mineral2.spoils);
            formattedOutputs.sort(Comparator.comparingDouble(i -> -i.chance()));
            formattedSpoils.sort(Comparator.comparingDouble(i -> -i.chance()));
            StringBuilder outputString = new StringBuilder();
            NonNullList sortedOres = NonNullList.m_122779_();
            for (Object sorted2 : formattedOutputs) {
                outputString.append("\n").append(new DecimalFormat("00.00").format(((StackWithChance)sorted2).chance() * 100.0f).replaceAll("\\G0", "\u00a0")).append("% ").append(((ItemStack)((StackWithChance)sorted2).stack().get()).m_41786_().getString());
                sortedOres.add((Object)((ItemStack)((StackWithChance)sorted2).stack().get()));
            }
            StringBuilder spoilString = new StringBuilder();
            sorted2 = formattedSpoils.iterator();
            while (sorted2.hasNext()) {
                StackWithChance sorted3 = (StackWithChance)sorted2.next();
                spoilString.append("\n").append(new DecimalFormat("00.00").format(sorted3.chance() * 100.0f).replaceAll("\\G0", "\u00a0")).append("% ").append(((ItemStack)sorted3.stack().get()).m_41786_().getString());
                sortedOres.add((Object)((ItemStack)sorted3.stack().get()));
            }
            specials.add(new ManualEntry.SpecialElementData(mineral2.m_6423_().toString(), 0, new ManualElementItem(ManualHelper.getManual(), (NonNullList<ItemStack>)sortedOres)));
            String desc = I18n.m_118938_((String)"ie.manual.entry.minerals_desc", (Object[])new Object[]{dimensionString, outputString.toString(), spoilString.toString()});
            if (text.length() > 0) {
                text.append("<np>");
            }
            text.append("<&").append(mineral2.m_6423_()).append(">").append(desc);
        }
        return Pair.of((Object)text.toString(), specials);
    }

    private static void addChangelogToManual() {
        TreeMap allChanges = new TreeMap(Comparator.reverseOrder());
        ComparableVersion currIEVer = new ComparableVersion(ImmersiveEngineering.VERSION);
        try (InputStream in = Minecraft.m_91087_().m_91098_().m_142591_(new ResourceLocation("immersiveengineering", "changelog.json")).m_6679_();){
            JsonElement ele = new JsonParser().parse((Reader)new InputStreamReader(in));
            JsonObject jsonObject = ele.getAsJsonObject();
            for (Object entry : jsonObject.entrySet()) {
                ComparableVersion version = new ComparableVersion((String)entry.getKey());
                ManualEntry manualEntry = IEManual.addVersionToManual(currIEVer, version, ((JsonElement)entry.getValue()).getAsString(), false);
                if (manualEntry == null) continue;
                allChanges.put(version, manualEntry);
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
        VersionChecker.CheckResult result = VersionChecker.getResult((IModInfo)ModLoadingContext.get().getActiveContainer().getModInfo());
        if (result.status() != VersionChecker.Status.PENDING && result.status() != VersionChecker.Status.FAILED) {
            for (Map.Entry entry : result.changes().entrySet()) {
                if (allChanges.containsKey(entry.getKey())) continue;
                allChanges.put((ComparableVersion)entry.getKey(), IEManual.addVersionToManual(currIEVer, (ComparableVersion)entry.getKey(), (String)entry.getValue(), true));
            }
        }
        ManualInstance ieMan = ManualHelper.getManual();
        Tree.InnerNode<ResourceLocation, ManualEntry> innerNode = ieMan.getRoot().getOrCreateSubnode(new ResourceLocation("immersiveengineering", ManualHelper.CAT_UPDATE), -2);
        for (Object entry : allChanges.values()) {
            ManualHelper.getManual().addEntry(innerNode, (ManualEntry)entry);
        }
    }

    private static ManualEntry addVersionToManual(ComparableVersion currVer, ComparableVersion version, String changes, boolean ahead) {
        String text = changes.replace("\t", "  ");
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
        builder.setContent(() -> {
            Object title = version.toString();
            if (ahead) {
                title = (String)title + " - " + I18n.m_118938_((String)"ie.manual.newerVersion", (Object[])new Object[0]);
            } else if (currVer.equals((Object)version)) {
                title = (String)title + " - " + I18n.m_118938_((String)"ie.manual.currentVersion", (Object[])new Object[0]);
            }
            return title;
        }, () -> "", () -> text);
        builder.setLocation(new ResourceLocation("immersiveengineering", "changelog_" + version.toString()));
        return builder.create();
    }

    static Component[][] formatToTable_ItemIntMap(Map<Component, Integer> map, String valueType) {
        ArrayList<Map.Entry<Component, Integer>> sortedMapArray = new ArrayList<Map.Entry<Component, Integer>>(map.entrySet());
        sortedMapArray.sort(Map.Entry.comparingByValue());
        ArrayList<Component[]> list = new ArrayList<Component[]>();
        try {
            for (Map.Entry entry : sortedMapArray) {
                Component item = (Component)entry.getKey();
                if (item == null) {
                    item = Component.m_130674_((String)((Component)entry.getKey()).toString());
                }
                int bt = (Integer)entry.getValue();
                Component am = Component.m_130674_((String)(bt + " " + valueType));
                list.add(new Component[]{item, am});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (Component[][])list.toArray((T[])new Component[0][]);
    }

    static ItemStack[] collectRecipeStacksFromJSON(JsonObject json) {
        ItemStack[] stacks;
        if (GsonHelper.m_13885_((JsonObject)json, (String)"recipes")) {
            JsonArray arr = json.get("recipes").getAsJsonArray();
            stacks = new ItemStack[arr.size()];
            for (int i = 0; i < stacks.length; ++i) {
                stacks[i] = CraftingHelper.getItemStack((JsonObject)arr.get(i).getAsJsonObject(), (boolean)true);
            }
        } else {
            JsonElement recipe = json.get("recipe");
            Preconditions.checkArgument((boolean)recipe.isJsonObject());
            stacks = new ItemStack[]{CraftingHelper.getItemStack((JsonObject)recipe.getAsJsonObject(), (boolean)true)};
        }
        return stacks;
    }

    static Fluid[] collectRecipeFluidsFromJSON(JsonObject json) {
        Fluid[] stacks;
        if (GsonHelper.m_13885_((JsonObject)json, (String)"recipes")) {
            JsonArray arr = json.get("recipes").getAsJsonArray();
            stacks = new Fluid[arr.size()];
            for (int i = 0; i < stacks.length; ++i) {
                stacks[i] = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)arr.get(i).getAsJsonObject(), (String)"fluid")));
            }
        } else {
            JsonElement recipe = json.get("recipe");
            Preconditions.checkArgument((boolean)recipe.isJsonObject());
            stacks = new Fluid[]{(Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)recipe.getAsJsonObject(), (String)"fluid")))};
        }
        return stacks;
    }
}

